/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.helper;

import java.util.List;

public class AllowedUsers {
    private boolean _anonymousAllowed;
    private boolean _anyConnectedUserAllowed;
    private List<String> _allowedUsers;
    private List<String> _deniedUsers;
    private List<String> _allowedGroups;
    private List<String> _deniedGroups;

    public AllowedUsers(boolean anonymousAllowed, boolean anyConnectedUserAllowed, List<String> allowedUsers, List<String> deniedUsers, List<String> allowedGroups, List<String> deniedGroups) {
        this._anonymousAllowed = anonymousAllowed;
        this._anyConnectedUserAllowed = anyConnectedUserAllowed;
        this._allowedUsers = allowedUsers;
        this._deniedUsers = deniedUsers;
        this._allowedGroups = allowedGroups;
        this._deniedGroups = deniedGroups;
    }

    public boolean isAnonymousAllowed() {
        return this._anonymousAllowed;
    }

    public boolean isAnyConnectedUserAllowed() {
        return !this._anonymousAllowed && this._anyConnectedUserAllowed;
    }

    public List<String> getAllowedUsers() {
        return this._allowedUsers;
    }

    public List<String> getDeniedUsers() {
        return this._deniedUsers;
    }

    public List<String> getAllowedGroups() {
        return this._allowedGroups;
    }

    public List<String> getDeniedGroups() {
        return this._deniedGroups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AllowedUsers<");
        Object[] fields = new Object[]{this._anonymousAllowed, this._anyConnectedUserAllowed, this._allowedUsers, this._deniedUsers, this._allowedGroups, this._deniedGroups};
        for (int i = 0; i < fields.length; ++i) {
            Object field = fields[i];
            if (i != 0) {
                sb.append(" | ");
            }
            sb.append(field);
        }
        sb.append(">");
        return sb.toString();
    }
}

