/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.helper;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.solr.helper.AllowedUsers;
import org.ametys.solr.helper.AmetysIOException;
import org.ametys.solr.helper.AmetysObjectDocumentInfo;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AmetysReadAccessHelper {
    private static final int __MAX_NB_DOC_IDS = 10000;
    private static final int __MAX_NB_BYTES = 0x200000;
    private static JsonFactory __jsonFactory = new JsonFactory();
    private static ObjectMapper __objectMapper = new ObjectMapper();
    private static Logger __logger = LoggerFactory.getLogger(AmetysReadAccessHelper.class);

    private AmetysReadAccessHelper() {
    }

    public static Map<String, AllowedUsers> readAccessForDocuments(String ametysUrl, String coreName, List<AmetysObjectDocumentInfo> documents, String segmentName) throws AmetysIOException {
        AmetysReadAccessHelper._checkNotNull(ametysUrl);
        String url = ametysUrl + (ametysUrl.endsWith("/") ? "" : "/") + "_cms/read-access/" + coreName + "/all-users";
        return AmetysReadAccessHelper._readAccessForAll(url, documents, segmentName);
    }

    private static void _checkNotNull(String ametysUrl) {
        if (ametysUrl == null) {
            __logger.error("Ametys URL cannot be null.");
            throw new IllegalArgumentException("ametysUrl cannot be null");
        }
    }

    private static Map<String, AllowedUsers> _readAccessForAll(String url, List<AmetysObjectDocumentInfo> documents, String segmentName) throws AmetysIOException {
        if (documents.isEmpty()) {
            __logger.debug("documents object is empty, no server call will be made for segment '{}'", (Object)segmentName);
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, AllowedUsers> allowedUsersByAmetysObject = new LinkedHashMap<String, AllowedUsers>();
        int aoDocLength = documents.size();
        for (int start = 0; start < aoDocLength; start += 10000) {
            int toIndex = Math.min(start + 10000, aoDocLength);
            int end = toIndex - 1;
            UrlEncodedFormEntity encodedDocIds = AmetysReadAccessHelper._encodeChunk(documents, start, toIndex);
            ArrayList<EntityWrapper> chunks = new ArrayList<EntityWrapper>();
            chunks.add(new EntityWrapper(encodedDocIds, start, end));
            int nextChunkCount = 1;
            while (AmetysReadAccessHelper._maxBytesCount(chunks) >= 0x200000L) {
                chunks.clear();
                int chunkSize = Double.valueOf(Math.ceil(10000.0f / (float)(++nextChunkCount))).intValue();
                __logger.debug("At least one chunk is too large for segment '{}'. Next chunk count will be {} with a chunk size of {}.", new Object[]{segmentName, nextChunkCount, chunkSize});
                for (int chunkStart = start; chunkStart < toIndex; chunkStart += chunkSize) {
                    int chunkToIndex = Math.min(chunkStart + chunkSize, toIndex);
                    int chunkEnd = chunkToIndex - 1;
                    UrlEncodedFormEntity chunkEncodedDocIds = AmetysReadAccessHelper._encodeChunk(documents, chunkStart, chunkToIndex);
                    chunks.add(new EntityWrapper(chunkEncodedDocIds, chunkStart, chunkEnd));
                }
                if (chunkSize != 1) continue;
                break;
            }
            AmetysReadAccessHelper._callAmetysForAll(url, chunks, allowedUsersByAmetysObject, segmentName);
        }
        return allowedUsersByAmetysObject;
    }

    private static long _maxBytesCount(List<EntityWrapper> chunks) {
        return chunks.stream().map(e -> e._encodedDocIds).mapToLong(AmetysReadAccessHelper::_formLength).max().getAsLong();
    }

    private static long _formLength(UrlEncodedFormEntity entity) {
        return entity.getContentLength();
    }

    private static UrlEncodedFormEntity _encodeChunk(List<AmetysObjectDocumentInfo> documents, int start, int toIndex) {
        String chunkStr = documents.subList(start, toIndex).stream().map(AmetysObjectDocumentInfo::getId).collect(Collectors.joining(","));
        return AmetysReadAccessHelper._encode(chunkStr);
    }

    private static UrlEncodedFormEntity _encode(String docIds) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("ids", docIds));
        return new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
    }

    private static void _callAmetysForAll(String url, List<EntityWrapper> chunks, Map<String, AllowedUsers> allowedUsersByAmetysObject, Object segmentKey) throws AmetysIOException {
        __logger.debug("Will try to query Ametys ({}) about read access {} times (number of computed chunks less than 2MB) for segment '{}'.", new Object[]{url, chunks.size(), segmentKey});
        for (EntityWrapper chunk : chunks) {
            allowedUsersByAmetysObject.putAll(AmetysReadAccessHelper._callAmetysForAll(url, chunk._encodedDocIds, chunk._startIndex, chunk._endIndex, segmentKey));
        }
    }

    private static Map<String, AllowedUsers> _callAmetysForAll(String url, UrlEncodedFormEntity encodedDocIds, int startIndex, int endIndex, Object segmentKey) throws AmetysIOException {
        __logger.debug("Try to query Ametys ({}) about read access on several (range {} to {} of ametys objects) documents for all users (segment '{}')...", new Object[]{url, startIndex, endIndex, segmentKey});
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)encodedDocIds);
        if (__logger.isDebugEnabled()) {
            __logger.debug("POST content size (in bytes): " + AmetysReadAccessHelper._formLength(encodedDocIds) + "\nIf trace level is enabled, the content of the POST will be displayed in next log entry.");
            if (__logger.isTraceEnabled()) {
                __logger.trace(AmetysReadAccessHelper._entityToString(encodedDocIds));
            }
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpClientContext context = HttpClientContext.create();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post, (HttpContext)context);
            if (response.getStatusLine().getStatusCode() != 200) {
                String message = "Unable to get read access from Ametys application (" + url + "). Response is: " + String.valueOf(response.getStatusLine());
                __logger.error(message);
                throw new AmetysIOException(message);
            }
            InputStream is = response.getEntity().getContent();
            JsonParser jsonParser = __jsonFactory.createParser(is);
            Map jsonObject = (Map)__objectMapper.readValue(jsonParser, LinkedHashMap.class);
            if (jsonObject.containsKey("error") || !jsonObject.containsKey("response")) {
                __logger.error("An unexpected error occured in Ametys application. Check the Ametys logs for more details.");
                return Collections.EMPTY_MAP;
            }
            Map allowedUsersByDoc = (Map)jsonObject.get("response");
            __logger.debug("Success when querying Ametys ({}) about read access on range {} to {} for all users (segment '{}')", new Object[]{url, startIndex, endIndex, segmentKey});
            LinkedHashMap<String, AllowedUsers> result = new LinkedHashMap<String, AllowedUsers>();
            for (String docId : allowedUsersByDoc.keySet()) {
                Map allowedUsers = (Map)allowedUsersByDoc.get(docId);
                result.put(docId, new AllowedUsers((Boolean)allowedUsers.get("anonymous"), (Boolean)allowedUsers.get("anyConnected"), (List)allowedUsers.get("allowedUsers"), (List)allowedUsers.get("deniedUsers"), (List)allowedUsers.get("allowedGroups"), (List)allowedUsers.get("deniedGroups")));
            }
            return result;
        }
        catch (IOException e) {
            throw new AmetysIOException("An unexpected error occured while trying to communicate with Ametys application. Please refer to Ametys logs.", e);
        }
    }

    private static String _entityToString(UrlEncodedFormEntity entity) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            entity.writeTo((OutputStream)baos);
            return baos.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            return "An error occured when trying to retrieve the POST entity as an encoded string for trace debugging: " + e.getMessage();
        }
    }

    private static class EntityWrapper {
        UrlEncodedFormEntity _encodedDocIds;
        int _startIndex;
        int _endIndex;

        EntityWrapper(UrlEncodedFormEntity encodedDocIds, int startIndex, int endIndex) {
            this._encodedDocIds = encodedDocIds;
            this._startIndex = startIndex;
            this._endIndex = endIndex;
        }
    }
}

