/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.helper;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.ametys.solr.helper.SegmentHelper;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;

public final class DebugMessageHelper {
    private DebugMessageHelper() {
    }

    public static String segmentNameFromReader(LeafReader reader, Logger targetLogger) {
        if (targetLogger.isDebugEnabled()) {
            SegmentReader segmentReader = SegmentHelper.getSegmentReader(reader);
            return segmentReader == null ? null : segmentReader.getSegmentName();
        }
        return null;
    }

    public static String searcherName(SolrIndexSearcher searcher, Logger targetLogger) {
        if (targetLogger.isDebugEnabled()) {
            String core = searcher.getCore().getName();
            try {
                SegmentInfos segmentInfos = SegmentInfos.readLatestCommit((Directory)searcher.getIndexReader().directory());
                int nbSegments = segmentInfos.size();
                String allSegmentInfoStr = StreamSupport.stream(segmentInfos.spliterator(), false).map(segmentCommitInfo -> DebugMessageHelper._segmentCommitInfoToString(segmentCommitInfo, targetLogger)).collect(Collectors.joining(", "));
                return String.format("Searcher[core=%s][#segments=%s][%s]", core, nbSegments, allSegmentInfoStr);
            }
            catch (IOException e) {
                targetLogger.debug("An unexpected exception occured. Unable to log segments.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static String _segmentCommitInfoToString(SegmentCommitInfo segmentCommitInfo, Logger targetLogger) {
        String name = segmentCommitInfo.info.name;
        Version version = segmentCommitInfo.info.getVersion();
        try {
            long size = segmentCommitInfo.sizeInBytes();
            int numDocs = segmentCommitInfo.info.maxDoc();
            int delCount = segmentCommitInfo.getDelCount();
            String source = (String)segmentCommitInfo.info.getDiagnostics().get("source");
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
            symbols.setGroupingSeparator('.');
            decimalFormat.setDecimalFormatSymbols(symbols);
            return name + "(version=" + String.valueOf(version == null ? "?" : version) + ", size=" + decimalFormat.format(size) + " bytes, #docs=" + decimalFormat.format(numDocs) + ", #dels=" + decimalFormat.format(delCount) + ", source=" + source + ")";
        }
        catch (IOException e) {
            targetLogger.debug("An unexpected exception occured. Unable to log segment {}.", (Object)name, (Object)e);
            return "<error>";
        }
    }
}

