/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.ametys.solr.plugins.ametys.AmetysQParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public class JoinParamParser {
    private final String _joinParam;
    private List<String> _joinParts;
    private List<String> _joinFields;
    private List<String> _nestedQueries;
    private Queue<String> _tokens;

    public JoinParamParser(String joinParam) {
        this._joinParam = joinParam;
    }

    public synchronized void parse() throws SyntaxError {
        this._tokens = new LinkedList<String>(Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)this._joinParam, (String)"->")));
        this._joinParts = new ArrayList<String>();
        this._joinFields = new ArrayList<String>();
        this._nestedQueries = new ArrayList<String>();
        Object token = null;
        while (!this._tokens.isEmpty()) {
            if (token == null) {
                token = this._tokens.poll();
                int openingIndex = this._unescapedIndexOf((String)token, '[', 0);
                if (openingIndex != -1) {
                    String joinPart = ((String)token).substring(0, openingIndex);
                    this._assertCorrectJoinPart(joinPart, (String)token);
                    this._parseJoinPart(joinPart);
                    boolean isFullyParsedNestedQuery = this._parseNestedQuery((String)(token = ((String)token).substring(openingIndex + 1, ((String)token).length())), null);
                    if (!isFullyParsedNestedQuery) continue;
                    token = null;
                    continue;
                }
                this._assertCorrectJoinPart((String)token, (String)token);
                this._parseJoinPart((String)token);
                this._nestedQueries.add(null);
                token = null;
                continue;
            }
            String tokenBefore = token + "->";
            token = this._tokens.poll();
            boolean isFullyParsedNestedQuery = this._parseNestedQuery((String)token, tokenBefore);
            if (isFullyParsedNestedQuery) {
                token = null;
                continue;
            }
            token = tokenBefore + (String)token;
        }
        if (token != null) {
            String firstLineMsg = "Syntax error with join. Missing a closing square bracket:";
            throw new SyntaxError(this._syntaxErrorMessage(firstLineMsg, this._joinParam.length() - ((String)token).length() - 1));
        }
    }

    public AmetysQParser.JoinKey[] collect(SolrQueryRequest request) throws SyntaxError {
        this._testIsParsed();
        ArrayList<MatchAllDocsQuery> nestedParsedQueries = new ArrayList<MatchAllDocsQuery>();
        for (String nestedQuery : this._nestedQueries) {
            MatchAllDocsQuery parsedQuery = null;
            if (nestedQuery != null) {
                try {
                    parsedQuery = QParser.getParser((String)nestedQuery, (SolrQueryRequest)request).getQuery();
                }
                catch (SolrException | SyntaxError e) {
                    throw new SyntaxError("An error occured when parsing the nested query: " + nestedQuery, e);
                }
                if (parsedQuery == null) {
                    throw new SyntaxError("The nested query '" + nestedQuery + "' could not be parsed by the Lucene query parser.");
                }
            }
            nestedParsedQueries.add(parsedQuery != null ? parsedQuery : new MatchAllDocsQuery());
        }
        return (AmetysQParser.JoinKey[])IntStream.rangeClosed(0, this._joinParts.size() - 1).mapToObj(i -> new AmetysQParser.JoinKey(this._suffixedKey(this._joinParts.get(i).trim()), this._suffixedKey(this._joinFields.get(i).trim()), (Query)nestedParsedQueries.get(i))).toArray(AmetysQParser.JoinKey[]::new);
    }

    private void _testIsParsed() {
        if (this._tokens == null) {
            throw new IllegalArgumentException("You must parse the join parameter before collecting");
        }
    }

    private String _suffixedKey(String key) {
        return key.endsWith("_s_dv") || key.equals("id_dv") ? key : key + "_s_dv";
    }

    public List<String> collectJoinParts(boolean withSuffix, boolean trimmed) {
        this._testIsParsed();
        Stream<Object> resultStream = this._joinParts.stream();
        if (trimmed) {
            resultStream = resultStream.map(String::trim);
        }
        if (withSuffix) {
            resultStream = resultStream.map(this::_suffixedKey);
        }
        return resultStream.collect(Collectors.toList());
    }

    public List<String> collectNestedQueries() {
        this._testIsParsed();
        return new ArrayList<String>(this._nestedQueries);
    }

    private int _unescapedIndexOf(String str, char searchChar, int nbToSkip) {
        String searchStr = Character.toString(searchChar);
        int ordinal = 1;
        int nbFound = 0;
        int index = StringUtils.ordinalIndexOf((CharSequence)str, (CharSequence)searchStr, (int)ordinal);
        while (index > 0 && ('\\' == str.charAt(index - 1) || nbToSkip + 1 > ++nbFound)) {
            index = StringUtils.ordinalIndexOf((CharSequence)str, (CharSequence)searchStr, (int)(++ordinal));
        }
        return index;
    }

    private int _unescapedCount(String str, char searchChar) {
        String searchStr = Character.toString(searchChar);
        int ordinal = 1;
        int nbFound = 0;
        int index = StringUtils.ordinalIndexOf((CharSequence)str, (CharSequence)searchStr, (int)ordinal);
        while (index > 0) {
            if ('\\' != str.charAt(index - 1)) {
                ++nbFound;
            }
            index = StringUtils.ordinalIndexOf((CharSequence)str, (CharSequence)searchStr, (int)(++ordinal));
        }
        return nbFound;
    }

    private void _assertCorrectJoinPart(String joinPart, String currentToken) throws SyntaxError {
        if (joinPart.isEmpty()) {
            throw new SyntaxError(this._syntaxErrorMessage("Syntax error, a join part is empty:", this._computePadding(currentToken, -1)));
        }
        int index = joinPart.indexOf("]");
        if (index != -1) {
            int padding = this._computePadding(currentToken, index);
            throw new SyntaxError(this._syntaxErrorMessage("Syntax error with a join part. The ']' character was encountered whereas it is forbidden for a field name. Perhaps a '[' is missing:", padding));
        }
    }

    private int _computePadding(String currentToken, int pos) {
        String unparsedTokens = (this._tokens.isEmpty() ? "" : "->") + StringUtils.join((Object[])this._tokens.toArray(), (String)"->");
        int leftPadding = this._joinParam.length() - unparsedTokens.length() - currentToken.length() + pos;
        return Math.max(leftPadding, 0);
    }

    private void _parseJoinPart(String joinPart) {
        int i = joinPart.indexOf("%");
        if (i != -1) {
            this._joinParts.add(joinPart.substring(0, i));
            this._joinFields.add(joinPart.substring(i + 1));
        } else {
            this._joinParts.add(joinPart);
            this._joinFields.add("id_dv");
        }
    }

    private boolean _parseNestedQuery(String token, String tokenBefore) throws SyntaxError {
        int nbToSkip = this._unescapedCount(token, '[');
        int closingIndex = this._unescapedIndexOf(token, ']', nbToSkip);
        if (closingIndex != -1 && closingIndex == token.length() - 1) {
            String tokenWithoutClosingBracket = token.substring(0, token.length() - 1);
            String nestedQuery = tokenBefore != null ? tokenBefore + tokenWithoutClosingBracket : tokenWithoutClosingBracket;
            this._nestedQueries.add(nestedQuery);
            return true;
        }
        if (closingIndex != -1) {
            throw new SyntaxError(this._syntaxErrorMessageCharAfterClosingBracket(token, closingIndex));
        }
        return false;
    }

    private String _syntaxErrorMessageCharAfterClosingBracket(String currentToken, int closingBracketIndex) {
        String firstLineMsg = "Syntax error with join. The ']' character must be followed by either the join separator '->', either the end of the whole join path:";
        return this._syntaxErrorMessage(firstLineMsg, this._computePadding(currentToken, closingBracketIndex));
    }

    private String _syntaxErrorMessage(String firstLineMsg, int leftPadding) {
        String secondLinePrefix = "in join ";
        int nbSpaces = secondLinePrefix.length() + leftPadding;
        String thirdLineMsg = StringUtils.leftPad((String)"^", (int)(nbSpaces + 1));
        String msgException = firstLineMsg + "\n" + secondLinePrefix + this._joinParam + "\n" + thirdLineMsg;
        return msgException;
    }
}

