/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.log;

import org.ametys.solr.helper.DebugMessageHelper;
import org.apache.solr.core.AbstractSolrEventListener;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSearcherListener
extends AbstractSolrEventListener {
    private static final Logger __LOGGER = LoggerFactory.getLogger(LogSearcherListener.class);

    public LogSearcherListener(SolrCore core) {
        super(core);
    }

    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
        if (__LOGGER.isDebugEnabled()) {
            this._logSearcherSegments(newSearcher);
        }
    }

    private void _logSearcherSegments(SolrIndexSearcher searcher) {
        String searcherName = DebugMessageHelper.searcherName(searcher, __LOGGER);
        __LOGGER.debug("New searcher: {}", (Object)searcherName);
    }
}

