/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.plugins.acl;

import java.util.Set;
import org.ametys.solr.helper.CoreHelper;
import org.ametys.solr.plugins.AbstractQParser;
import org.ametys.solr.plugins.acl.AclQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class AclQParser
extends AbstractQParser {
    public static final String IS_AMETYS_OBJECT_FIELD = "ametysObject";
    public static final String ANONYMOUS_PARAM = "anonymous";
    public static final String POPULATION_PARAM = "populationId";
    public static final String LOGIN_PARAM = "login";
    public static final String GROUPS_PARAM = "groups";

    public AclQParser(String q, SolrParams localParameters, SolrParams parameters, SolrQueryRequest request) {
        super(q, localParameters, parameters, request);
    }

    public Query parse() throws SyntaxError {
        boolean anonymous = this.localParams.get(ANONYMOUS_PARAM) != null;
        String population = this.localParams.get(POPULATION_PARAM);
        String login = this.localParams.get(LOGIN_PARAM);
        Set<String> groups = this._paramToSet(GROUPS_PARAM);
        SolrIndexSearcher searcher = this.req.getSearcher();
        String ametysUrl = CoreHelper.getAmetysUrl(this.req.getCore());
        if (anonymous) {
            return new AclQuery(searcher, ametysUrl);
        }
        if (StringUtils.isEmpty((CharSequence)population) || StringUtils.isEmpty((CharSequence)login)) {
            return null;
        }
        return new AclQuery(searcher, ametysUrl, population, login, groups);
    }
}

