/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.plugins.acl;

import java.io.IOException;
import java.util.Set;
import org.ametys.solr.plugins.AbstractAclBaseQuery;
import org.ametys.solr.plugins.acl.AclQueryWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexSearcher;

public class AclQuery
extends AbstractAclBaseQuery {
    private SolrIndexSearcher _searcher;
    private String _ametysUrl;
    private boolean _anonymous;
    private String _populationId;
    private String _login;
    private Set<String> _groups;

    public AclQuery(SolrIndexSearcher searcher, String ametysUrl) {
        this._searcher = searcher;
        this._ametysUrl = ametysUrl;
        this._anonymous = true;
    }

    public AclQuery(SolrIndexSearcher searcher, String ametysUrl, String populationId, String login, Set<String> groups) {
        this._searcher = searcher;
        this._ametysUrl = ametysUrl;
        this._populationId = populationId;
        this._login = login;
        this._groups = groups;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new AclQueryWeight(this._searcher, this, this._ametysUrl, this._anonymous, this._populationId, this._login, this._groups);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (this._anonymous) {
            sb.append("for_anonymous");
        } else {
            sb.append("login=").append(this._login).append(" population=").append(this._populationId).append(" groups=").append(this._groups);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._anonymous ? 1231 : 1237);
        result = 31 * result + (this._groups == null ? 0 : this._groups.hashCode());
        result = 31 * result + (this._login == null ? 0 : this._login.hashCode());
        result = 31 * result + (this._populationId == null ? 0 : this._populationId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AclQuery other = (AclQuery)((Object)obj);
        if (this._anonymous != other._anonymous) {
            return false;
        }
        if (this._groups == null ? other._groups != null : !this._groups.equals(other._groups)) {
            return false;
        }
        if (this._login == null ? other._login != null : !this._login.equals(other._login)) {
            return false;
        }
        return !(this._populationId == null ? other._populationId != null : !this._populationId.equals(other._populationId));
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }
}

