/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.plugins.acl;

import java.io.IOException;
import java.util.Set;
import org.ametys.solr.helper.AclCacheManager;
import org.ametys.solr.helper.AmetysIOException;
import org.ametys.solr.plugins.acl.AclQuery;
import org.ametys.solr.plugins.acl.AclQueryScorer;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.LoggerFactory;

public class AclQueryWeight
extends Weight {
    private SolrIndexSearcher _searcher;
    private String _ametysUrl;
    private boolean _anonymous;
    private String _population;
    private String _login;
    private Set<String> _groups;

    public AclQueryWeight(SolrIndexSearcher searcher, AclQuery query, String ametysUrl, boolean anonymous, String population, String login, Set<String> groups) {
        super((Query)query);
        this._searcher = searcher;
        this._ametysUrl = ametysUrl;
        this._anonymous = anonymous;
        this._population = population;
        this._login = login;
        this._groups = groups;
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        FixedBitSet bitSet = null;
        try {
            bitSet = AclCacheManager.getOrComputeBitSet(this._searcher, reader, this._anonymous, this._population, this._login, this._groups, this._ametysUrl);
        }
        catch (AmetysIOException e) {
            LoggerFactory.getLogger(AclQueryWeight.class).error("An error occured when communicating with Ametys application. The query could not be executed correctly. All contents will be marked as not allowed.", (Throwable)e);
            AclCacheManager.putNoAllowedUserInCache(this._searcher);
            return new AclQueryScorer(this, (DocIdSetIterator)new BitSetIterator((BitSet)new FixedBitSet(0), 1L));
        }
        return new AclQueryScorer(this, (DocIdSetIterator)new BitSetIterator((BitSet)bitSet, 1L));
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        Scorer scorer = this.scorer(context);
        if (scorer != null && scorer.iterator().advance(doc) == doc) {
            return Explanation.match((Number)Float.valueOf(scorer.score()), (String)"ACL match", (Explanation[])new Explanation[0]);
        }
        return Explanation.noMatch((String)"No ACL match", (Explanation[])new Explanation[0]);
    }
}

