/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.plugins.aclcompare;

import java.util.List;
import org.ametys.solr.helper.AllowedUsers;
import org.ametys.solr.helper.CoreHelper;
import org.ametys.solr.plugins.AbstractQParser;
import org.ametys.solr.plugins.aclcompare.AclCompareQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class AclCompareQParser
extends AbstractQParser {
    public static final String ANONYMOUS_PARAM = "anonymous";
    public static final String ANY_CONNECTED_PARAM = "anyConnected";
    public static final String ALLOWED_USERS_PARAM = "allowedUsers";
    public static final String DENIED_USERS_PARAM = "deniedUsers";
    public static final String ALLOWED_GROUPS_PARAM = "allowedGroups";
    public static final String DENIED_GROUPS_PARAM = "deniedGroups";

    public AclCompareQParser(String q, SolrParams localParameters, SolrParams parameters, SolrQueryRequest request) {
        super(q, localParameters, parameters, request);
    }

    public Query parse() throws SyntaxError {
        boolean anonymous = this.localParams.getBool(ANONYMOUS_PARAM, false);
        boolean anyConnected = this.localParams.getBool(ANY_CONNECTED_PARAM, false);
        List<String> allowedUsers = this._paramToList(ALLOWED_USERS_PARAM);
        List<String> deniedUsers = this._paramToList(DENIED_USERS_PARAM);
        List<String> allowedGroups = this._paramToList(ALLOWED_GROUPS_PARAM);
        List<String> deniedGroups = this._paramToList(DENIED_GROUPS_PARAM);
        AllowedUsers allowedUsersObj = new AllowedUsers(anonymous, anyConnected, allowedUsers, deniedUsers, allowedGroups, deniedGroups);
        SolrIndexSearcher searcher = this.req.getSearcher();
        String ametysUrl = CoreHelper.getAmetysUrl(this.req.getCore());
        return new AclCompareQuery(searcher, ametysUrl, allowedUsersObj);
    }
}

