/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.sort;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.SolrIndexSearcher;

abstract class AbstractJoinComparator<T>
extends SimpleFieldComparator<T> {
    String _finalField;
    IndexSchema _schema;
    SolrIndexSearcher _searcher;
    String[] _joinFields;
    boolean _reverse;
    long[] _values;
    long _bottomValue;
    long _topValue;
    LeafReaderContext _context;
    Map<String, OrdinalMap> _ordMaps = new HashMap<String, OrdinalMap>();
    Map<String, SortedDocValues> _globalDocValues = new HashMap<String, SortedDocValues>();
    Map<Integer, Long>[] _valuesCache;

    AbstractJoinComparator(int numHits, IndexSchema schema, SolrIndexSearcher searcher, String[] joinFields, String finalField, boolean reverse) {
        this._schema = schema;
        this._searcher = searcher;
        this._joinFields = (String[])ArrayUtils.clone((Object[])joinFields);
        this._finalField = finalField;
        this._reverse = reverse;
        this._values = new long[numHits];
        this._valuesCache = new Map[this._joinFields.length];
        for (String joinField : joinFields) {
            this._computeGlobalOrdAndDocValues(joinField);
        }
    }

    public void copy(int slot, int doc) throws IOException {
        this._values[slot] = this._getValue(doc);
    }

    public int compare(int slot1, int slot2) {
        return this._compare(this._values[slot1], this._values[slot2]);
    }

    public void setBottom(int slot) throws IOException {
        this._bottomValue = this._values[slot];
    }

    public int compareBottom(int doc) throws IOException {
        return this._compare(this._bottomValue, this._getValue(doc));
    }

    public int compareTop(int doc) throws IOException {
        return this._compare(this._topValue, this._getValue(doc));
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this._context = context;
    }

    int _compare(long val1, long val2) {
        return Long.compare(val1, val2);
    }

    int _ord(int doc, int readerIndex, String field) throws IOException {
        SortedDocValues sortedDocValues;
        LeafReader leafReader = ((LeafReaderContext)this._searcher.getLeafContexts().get(readerIndex)).reader();
        FieldType fieldType = this._schema.getFieldType(field);
        if (fieldType instanceof TextField || this._isMultiple(field)) {
            SortedSetDocValues sortedSetDocValues = leafReader.getSortedSetDocValues(field);
            sortedDocValues = DocValues.unwrapSingleton((SortedSetDocValues)sortedSetDocValues);
            if (sortedDocValues == null) {
                sortedDocValues = SortedSetSelector.wrap((SortedSetDocValues)sortedSetDocValues, (SortedSetSelector.Type)SortedSetSelector.Type.MIN);
            }
        } else {
            sortedDocValues = leafReader.getSortedDocValues(field);
        }
        if (sortedDocValues.advanceExact(doc)) {
            return sortedDocValues.ordValue();
        }
        return -1;
    }

    private boolean _isMultiple(String fieldName) {
        return this._schema.getField(fieldName).multiValued();
    }

    void _computeGlobalOrdAndDocValues(String field) {
        if (this._globalDocValues.containsKey(field) && this._ordMaps.containsKey(field)) {
            return;
        }
        try {
            SortedDocValues sortedDocValues;
            FieldType type = this._schema.getFieldType(field);
            LeafReader reader = this._searcher.getSlowAtomicReader();
            OrdinalMap ordinalMap = null;
            if (type instanceof TextField || this._isMultiple(field)) {
                SortedSetDocValues sortedSetDocValues = reader.getSortedSetDocValues(field);
                if (sortedSetDocValues instanceof MultiDocValues.MultiSortedSetDocValues) {
                    MultiDocValues.MultiSortedSetDocValues multiDocValues = (MultiDocValues.MultiSortedSetDocValues)sortedSetDocValues;
                    ordinalMap = multiDocValues.mapping;
                }
                sortedDocValues = SortedSetSelector.wrap((SortedSetDocValues)sortedSetDocValues, (SortedSetSelector.Type)SortedSetSelector.Type.MIN);
            } else {
                sortedDocValues = reader.getSortedDocValues(this._finalField);
                if (sortedDocValues instanceof MultiDocValues.MultiSortedDocValues) {
                    MultiDocValues.MultiSortedDocValues multiDocValues = (MultiDocValues.MultiSortedDocValues)sortedDocValues;
                    ordinalMap = multiDocValues.mapping;
                }
            }
            this._globalDocValues.put(field, sortedDocValues);
            this._ordMaps.put(field, ordinalMap);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while computing global ords for field " + this._finalField, e);
        }
    }

    private long _getValue(int doc) throws IOException {
        return this._getValue(doc, this._context.ord, 0);
    }

    private long _getValue(int doc, int reader, int joinIndex) throws IOException {
        Map<Integer, Long> globalOrdCache;
        if (joinIndex == this._joinFields.length) {
            return this._getSortValue(doc, reader);
        }
        String joinField = this._joinFields[joinIndex];
        int ord = this._ord(doc, reader, joinField);
        if (ord == -1) {
            return -1L;
        }
        int globalOrd = this._getGlobalOrd(ord, reader, this._ordMaps.get(joinField));
        if (this._valuesCache[joinIndex] == null) {
            this._valuesCache[joinIndex] = new HashMap<Integer, Long>();
        }
        if ((globalOrdCache = this._valuesCache[joinIndex]).containsKey(globalOrd)) {
            return globalOrdCache.get(globalOrd);
        }
        BytesRef id = this._globalDocValues.get(joinField).lookupOrd(globalOrd);
        if (id == null) {
            return -1L;
        }
        long target = this._searcher.lookupId(id);
        long result = -1L;
        if (target != -1L) {
            int nextDoc = (int)target;
            int nextReader = (int)(target >> 32);
            result = this._getValue(nextDoc, nextReader, joinIndex + 1);
        }
        globalOrdCache.put(globalOrd, result);
        return result;
    }

    int _getGlobalOrd(int ord, int subIndex, OrdinalMap map) {
        if (map == null) {
            return ord;
        }
        LongValues ordMap = map.getGlobalOrds(subIndex);
        return (int)ordMap.get((long)ord);
    }

    abstract long _getSortValue(int var1, int var2) throws IOException;

    static class NumericJoinComparator
    extends AbstractJoinComparator<Long> {
        NumericJoinComparator(int numHits, IndexSchema schema, SolrIndexSearcher searcher, String[] joinFields, String finalField, boolean reverse) {
            super(numHits, schema, searcher, joinFields, finalField, reverse);
        }

        public void setTopValue(Long value) {
            this._topValue = value;
        }

        public Long value(int slot) {
            return this._values[slot];
        }

        @Override
        long _getSortValue(int doc, int readerIndex) throws IOException {
            LeafReader leafReader = ((LeafReaderContext)this._searcher.getLeafContexts().get(readerIndex)).reader();
            NumericDocValues docValues = leafReader.getNumericDocValues(this._finalField);
            if (docValues.advanceExact(doc)) {
                return docValues.longValue();
            }
            return -1L;
        }
    }

    static class BoolJoinComparator
    extends StringJoinComparator {
        BoolJoinComparator(int numHits, IndexSchema schema, SolrIndexSearcher searcher, String[] joinFields, String finalField, boolean reverse) {
            super(numHits, schema, searcher, joinFields, finalField, reverse, false);
        }
    }

    static class StringJoinComparator
    extends AbstractJoinComparator<BytesRef> {
        private boolean _forceMissingLast;

        StringJoinComparator(int numHits, IndexSchema schema, SolrIndexSearcher searcher, String[] joinFields, String finalField, boolean reverse) {
            this(numHits, schema, searcher, joinFields, finalField, reverse, true);
        }

        StringJoinComparator(int numHits, IndexSchema schema, SolrIndexSearcher searcher, String[] joinFields, String finalField, boolean reverse, boolean forceMissingLast) {
            super(numHits, schema, searcher, joinFields, finalField, reverse);
            this._forceMissingLast = forceMissingLast;
            this._computeGlobalOrdAndDocValues(this._finalField);
        }

        @Override
        int _compare(long val1, long val2) {
            int returnValue;
            if (!this._forceMissingLast) {
                return super._compare(val1, val2);
            }
            int n = returnValue = this._reverse ? -1 : 1;
            if (val1 == -1L) {
                return val2 == -1L ? 0 : returnValue;
            }
            if (val2 == -1L) {
                return -returnValue;
            }
            return Long.compare(val1, val2);
        }

        @Override
        long _getSortValue(int doc, int reader) throws IOException {
            int ord = this._ord(doc, reader, this._finalField);
            return ord == -1 ? -1L : (long)this._getGlobalOrd(ord, reader, (OrdinalMap)this._ordMaps.get(this._finalField));
        }

        public BytesRef value(int slot) {
            try {
                int ord = (int)this._values[slot];
                if (ord == -1) {
                    return null;
                }
                BytesRef result = ((SortedDocValues)this._globalDocValues.get(this._finalField)).lookupOrd(ord);
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while getting value for slot " + slot, e);
            }
        }

        public void setTopValue(BytesRef value) {
            try {
                this._topValue = ((SortedDocValues)this._globalDocValues.get(this._finalField)).lookupTerm(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while computing top ord for value " + value.utf8ToString(), e);
            }
        }
    }
}

