/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.update;

import java.io.IOException;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreAutoCommitUpdateProcessor
extends UpdateRequestProcessor {
    private static final Logger __LOGGER = LoggerFactory.getLogger(IgnoreAutoCommitUpdateProcessor.class);

    public IgnoreAutoCommitUpdateProcessor(UpdateRequestProcessor nextProcessor) {
        super(nextProcessor);
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        this._ignoreAutoCommit((UpdateCommand)cmd);
        super.processAdd(cmd);
    }

    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        this._ignoreAutoCommit((UpdateCommand)cmd);
        super.processDelete(cmd);
    }

    public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
        this._ignoreAutoCommit((UpdateCommand)cmd);
        super.processMergeIndexes(cmd);
    }

    private void _ignoreAutoCommit(UpdateCommand cmd) {
        __LOGGER.debug("Ignoring autocommit for command '{}'", (Object)cmd);
        cmd.setFlags(cmd.getFlags() | UpdateCommand.IGNORE_AUTOCOMMIT);
    }
}

