/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.update;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.OneMergeWrappingMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.index.MergePolicyFactoryArgs;
import org.apache.solr.index.WrapperMergePolicyFactory;
import org.apache.solr.schema.IndexSchema;

public class SegmentsAwareMergePolicyFactory
extends WrapperMergePolicyFactory {
    public SegmentsAwareMergePolicyFactory(SolrResourceLoader resourceLoader, MergePolicyFactoryArgs args, IndexSchema schema) {
        super(resourceLoader, args, schema);
    }

    protected MergePolicy getMergePolicyInstance(MergePolicy wrappedMP) {
        return new OneMergeWrappingMergePolicy(wrappedMP, merge -> new SegmentsAwareOneMerge(merge.segments));
    }

    public static class SegmentsAwareOneMerge
    extends MergePolicy.OneMerge {
        public static final String MERGED_SEGMENTS = "mergedSegments";
        public static final String MERGED_SEGMENTS_SEPARATOR = ";";

        SegmentsAwareOneMerge(List<SegmentCommitInfo> segments) {
            super(segments);
        }

        public void setMergeInfo(SegmentCommitInfo info) {
            info.info.addDiagnostics(Map.of(MERGED_SEGMENTS, this.segments.stream().map(i -> i.info.name).collect(Collectors.joining(MERGED_SEGMENTS_SEPARATOR))));
            super.setMergeInfo(info);
        }
    }
}

