/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.security.AuditEvent;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;
import org.apache.solr.servlet.HttpSolrCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private AuthorizationUtils() {
    }

    public static AuthorizationFailure authorize(HttpServletRequest servletReq, HttpServletResponse response, CoreContainer cores, AuthorizationContext context) throws IOException {
        log.debug("AuthorizationContext : {}", (Object)context);
        AuthorizationPlugin authzPlugin = cores.getAuthorizationPlugin();
        if (authzPlugin == null) {
            return null;
        }
        AuthorizationResponse authResponse = authzPlugin.authorize(context);
        int statusCode = authResponse.statusCode;
        if (statusCode == AuthorizationResponse.PROMPT.statusCode) {
            Map headers = (Map)servletReq.getAttribute(AuthenticationPlugin.class.getName());
            if (headers != null) {
                for (Map.Entry e : headers.entrySet()) {
                    response.setHeader((String)e.getKey(), (String)e.getValue());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("USER_REQUIRED {} {}", (Object)servletReq.getHeader("Authorization"), (Object)servletReq.getUserPrincipal());
            }
            if (HttpSolrCall.shouldAudit(cores, AuditEvent.EventType.REJECTED)) {
                cores.getAuditLoggerPlugin().doAudit(new AuditEvent(AuditEvent.EventType.REJECTED, servletReq, context));
            }
            return new AuthorizationFailure(statusCode, "Authentication failed, Response code: " + statusCode);
        }
        if (statusCode == AuthorizationResponse.FORBIDDEN.statusCode) {
            if (log.isDebugEnabled()) {
                log.debug("UNAUTHORIZED auth header {} context : {}, msg: {}", new Object[]{servletReq.getHeader("Authorization"), context, authResponse.getMessage()});
            }
            if (HttpSolrCall.shouldAudit(cores, AuditEvent.EventType.UNAUTHORIZED)) {
                cores.getAuditLoggerPlugin().doAudit(new AuditEvent(AuditEvent.EventType.UNAUTHORIZED, servletReq, context));
            }
            return new AuthorizationFailure(statusCode, "Unauthorized request, Response code: " + statusCode);
        }
        if (statusCode != 202 && statusCode != 200) {
            log.warn("ERROR {} during authentication: {}", (Object)statusCode, (Object)authResponse.getMessage());
            if (HttpSolrCall.shouldAudit(cores, AuditEvent.EventType.ERROR)) {
                cores.getAuditLoggerPlugin().doAudit(new AuditEvent(AuditEvent.EventType.ERROR, servletReq, context));
            }
            return new AuthorizationFailure(statusCode, "ERROR during authorization, Response code: " + statusCode);
        }
        if (HttpSolrCall.shouldAudit(cores, AuditEvent.EventType.AUTHORIZED)) {
            cores.getAuditLoggerPlugin().doAudit(new AuditEvent(AuditEvent.EventType.AUTHORIZED, servletReq, context));
        }
        return null;
    }

    public static List<AuthorizationContext.CollectionRequest> getCollectionRequests(String path, List<String> collectionNames, SolrParams params) {
        ArrayList<AuthorizationContext.CollectionRequest> collectionRequests = new ArrayList<AuthorizationContext.CollectionRequest>();
        if (collectionNames != null) {
            for (String collection : collectionNames) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(collection));
            }
        }
        if (path.equals("/admin/collections")) {
            if (CollectionParams.CollectionAction.CREATE.isEqual(params.get("action")) || CollectionParams.CollectionAction.RELOAD.isEqual(params.get("action")) || CollectionParams.CollectionAction.DELETE.isEqual(params.get("action"))) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(params.get("name")));
            } else if (params.get("collection") != null) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(params.get("collection")));
            }
        }
        return collectionRequests;
    }

    public static class AuthorizationFailure {
        private final int statusCode;
        private final String message;

        public AuthorizationFailure(int statusCode, String message) {
            this.statusCode = statusCode;
            this.message = message;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

