/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.core;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.ametys.solr.helper.CoreHelper;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CorePropertiesLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmetysCorePropertiesLocator
extends CorePropertiesLocator {
    private static Logger __logger = LoggerFactory.getLogger(AmetysCorePropertiesLocator.class);
    protected final Path _rootDirectory;

    public AmetysCorePropertiesLocator(Path coreDiscoveryRoot) {
        super(coreDiscoveryRoot);
        this._rootDirectory = coreDiscoveryRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changePropertyValue(CoreContainer cc, CoreDescriptor cd, String propertyName, String newPropertyValue) {
        String currentPropertyVal = CoreHelper.getProperty(cd, propertyName);
        if (newPropertyValue.equals(currentPropertyVal)) {
            return false;
        }
        CoreDescriptor coreDescriptor = cd;
        synchronized (coreDescriptor) {
            Properties p = this.buildCoreProperties(cd);
            p.put(propertyName, newPropertyValue);
            Path tmpPropertiesFile = this._rootDirectory.resolve(cd.getInstanceDir()).resolve("core.properties.new");
            this._ensureFileDoNotExist(tmpPropertiesFile);
            try (OutputStreamWriter os = new OutputStreamWriter(Files.newOutputStream(tmpPropertiesFile, new OpenOption[0]), StandardCharsets.UTF_8);){
                p.store(os, "Written by " + ((Object)((Object)this)).getClass().getSimpleName());
            }
            catch (IOException e) {
                __logger.error("Couldn't persist core properties to {}", (Object)tmpPropertiesFile, (Object)e);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Couldn't persist core properties to " + tmpPropertiesFile.toAbsolutePath().toString() + " : " + e.getMessage());
            }
            Path toOverridePropertiesFile = this._rootDirectory.resolve(cd.getInstanceDir()).resolve("core.properties");
            this._rename(tmpPropertiesFile, toOverridePropertiesFile);
            this._updateCoreDescriptor(cd, propertyName, newPropertyValue);
        }
        return true;
    }

    private void _ensureFileDoNotExist(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (Exception e) {
                __logger.error("Couldn't delete temporary core properties {}", (Object)file, (Object)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't delete temporary core properties " + file.toAbsolutePath().toString() + " : " + e.getMessage());
            }
        }
    }

    private void _rename(Path oldFile, Path newFile) {
        try {
            Files.delete(newFile);
        }
        catch (Exception e) {
            __logger.error("Couldn't delete current core properties {}", (Object)newFile, (Object)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't delete current core properties " + newFile.toAbsolutePath().toString() + " : " + e.getMessage());
        }
        try {
            Files.move(oldFile, newFile, new CopyOption[0]);
        }
        catch (Exception e) {
            __logger.error("Couldn't rename temporary core properties {} to real core properties {}", new Object[]{oldFile, newFile, e});
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't rename temporary core properties " + oldFile.toAbsolutePath().toString() + " to real core properties " + newFile.toAbsolutePath().toString() + " : " + e.getMessage());
        }
    }

    private void _updateCoreDescriptor(CoreDescriptor cd, String propertyName, String newPropertyValue) {
        Properties userProperties = cd.getPersistableUserProperties();
        userProperties.put(propertyName, newPropertyValue);
        if (!cd.getSubstitutableProperties().containsKey(propertyName)) {
            throw new IllegalStateException("Should not happen");
        }
        cd.getSubstitutableProperties().setProperty(propertyName, newPropertyValue);
    }
}

