/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.facets;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ametys.solr.helper.JoinHelper;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.join.SeekingTermSetTermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.NumberType;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SyntaxError;

class AmetysSimpleFacets
extends SimpleFacets {
    AmetysSimpleFacets(SolrQueryRequest request, DocSet docs, SolrParams params, ResponseBuilder responseBuilder) {
        super(request, docs, params, responseBuilder);
    }

    public NamedList<Object> getFacetFieldCounts() throws IOException, SyntaxError {
        NamedList res = super.getFacetFieldCounts();
        this._handleJoins((NamedList<Object>)res);
        return res;
    }

    private void _handleJoins(NamedList<Object> result) throws SyntaxError, IOException {
        String[] facetJoins = this.global.getParams("facet.ametys");
        if (facetJoins == null || facetJoins.length == 0) {
            return;
        }
        for (String facetJoin : facetJoins) {
            String joinField;
            JoinResult joinResult;
            SimpleFacets.ParsedParams parsed = this.parseParams("facet.ametys", facetJoin);
            String key = parsed.key;
            String join = parsed.facetValue;
            if (parsed.docs.size() == 0) {
                result.add(key, (Object)new NamedList());
                continue;
            }
            int i = join.indexOf(",");
            String facetField = join.substring(i + 1).trim();
            String facetKeys = join.substring(0, i);
            String[] keys = JoinHelper.getFinalKeys(facetKeys);
            HashMap<LeafReaderContext, DocIdSetIterator> queryResults = new HashMap<LeafReaderContext, DocIdSetIterator>();
            for (LeafReaderContext leaf : this.searcher.getTopReaderContext().leaves()) {
                queryResults.put(leaf, parsed.docs.iterator(leaf));
            }
            Map<LeafReaderContext, DocIdSetIterator> docs = queryResults;
            Map<Integer, DocIdSet> correspondingResults = null;
            String[] stringArray = keys;
            int n = stringArray.length;
            for (int j = 0; j < n && !(docs = (joinResult = this._join(correspondingResults, docs, joinField = stringArray[j])).docs()).isEmpty(); ++j) {
                correspondingResults = joinResult.correspondingResults();
            }
            NamedList<Integer> joinCount = docs.isEmpty() ? new NamedList<Integer>() : this._count(docs, correspondingResults, facetField);
            result.add(key, joinCount);
        }
    }

    private JoinResult _join(Map<Integer, DocIdSet> currentCorrespondingResults, Map<LeafReaderContext, DocIdSetIterator> docs, String field) throws IOException {
        Matches matches = this._computeMatches(docs, currentCorrespondingResults, field, true);
        BytesRefHash terms = matches.terms();
        Map<BytesRef, DocIdSet> correspondingResults = matches.correspondingResults();
        if (terms.size() == 0) {
            return new JoinResult(Map.of(), Map.of());
        }
        return this._getTargetDocs(correspondingResults, terms);
    }

    private Matches _computeMatches(Map<LeafReaderContext, DocIdSetIterator> docs, Map<Integer, DocIdSet> currentCorrespondingResults, String field, boolean collectTerms) throws IOException {
        boolean multivalued = this.searcher.getSchema().getField(field).multiValued();
        GlobalOrdAndDocValues globalOrdAndDocValues = this._getGlobalOrdAndDocValues(field, multivalued);
        OrdinalMap ordinalMap = globalOrdAndDocValues.ordinalMap();
        SortedSetDocValues globalDocValues = globalOrdAndDocValues.globalDocValues();
        HashMap<Integer, DocIdSetBuilder> resultBuilders = new HashMap<Integer, DocIdSetBuilder>();
        List leaves = this.searcher.getTopReaderContext().leaves();
        for (int subIndex = 0; subIndex < leaves.size(); ++subIndex) {
            SortedSetDocValues joinValues;
            LeafReaderContext leaf = (LeafReaderContext)leaves.get(subIndex);
            DocIdSetIterator docsIt = docs.get(leaf);
            if (docsIt == null) continue;
            SortedSetDocValues sortedSetDocValues = joinValues = multivalued ? leaf.reader().getSortedSetDocValues(field) : DocValues.singleton((SortedDocValues)leaf.reader().getSortedDocValues(field));
            if (joinValues == null || joinValues.getValueCount() <= 0L) continue;
            DocIdSetIterator it = ConjunctionUtils.createConjunction(List.of(joinValues, docsIt), List.of());
            int docId = it.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                int globalDocId = docId + leaf.docBase;
                for (int i = 0; i < joinValues.docValueCount(); ++i) {
                    int ord = (int)this._getGlobalOrd(joinValues.nextOrd(), subIndex, ordinalMap);
                    DocIdSetBuilder builder = resultBuilders.computeIfAbsent(ord, __ -> new DocIdSetBuilder(this.searcher.maxDoc()));
                    if (currentCorrespondingResults == null) {
                        builder.grow(1).add(globalDocId);
                        continue;
                    }
                    builder.add(currentCorrespondingResults.get(globalDocId).iterator());
                }
                docId = it.nextDoc();
            }
        }
        HashMap<BytesRef, DocIdSet> correspondingResults = new HashMap<BytesRef, DocIdSet>();
        BytesRefHash terms = collectTerms ? new BytesRefHash() : null;
        Iterator iterator = resultBuilders.keySet().iterator();
        while (iterator.hasNext()) {
            int ord = (Integer)iterator.next();
            BytesRef term = BytesRef.deepCopyOf((BytesRef)globalDocValues.lookupOrd((long)ord));
            correspondingResults.put(term, ((DocIdSetBuilder)resultBuilders.get(ord)).build());
            if (terms == null) continue;
            terms.add(term);
        }
        return new Matches(correspondingResults, terms);
    }

    private GlobalOrdAndDocValues _getGlobalOrdAndDocValues(String field, boolean multivalued) throws IOException {
        SortedSetDocValues globalDocValues;
        LeafReader reader = this.searcher.getSlowAtomicReader();
        OrdinalMap ordinalMap = null;
        if (multivalued) {
            globalDocValues = reader.getSortedSetDocValues(field);
            if (globalDocValues instanceof MultiDocValues.MultiSortedSetDocValues) {
                MultiDocValues.MultiSortedSetDocValues multiDocValues = (MultiDocValues.MultiSortedSetDocValues)globalDocValues;
                ordinalMap = multiDocValues.mapping;
            }
        } else {
            SortedDocValues docValues = reader.getSortedDocValues(field);
            globalDocValues = DocValues.singleton((SortedDocValues)docValues);
            if (docValues instanceof MultiDocValues.MultiSortedDocValues) {
                MultiDocValues.MultiSortedDocValues multiDocValues = (MultiDocValues.MultiSortedDocValues)docValues;
                ordinalMap = multiDocValues.mapping;
            }
        }
        return new GlobalOrdAndDocValues(ordinalMap, globalDocValues);
    }

    private JoinResult _getTargetDocs(Map<BytesRef, DocIdSet> correspondingResults, BytesRefHash terms) throws IOException {
        HashMap<LeafReaderContext, DocIdSetIterator> nextDocs = new HashMap<LeafReaderContext, DocIdSetIterator>();
        HashMap<Integer, DocIdSet> nextCorrespondingResults = new HashMap<Integer, DocIdSet>();
        for (LeafReaderContext leaf : this.searcher.getTopReaderContext().leaves()) {
            DocIdSetBuilder builder = null;
            TermsEnum ids = leaf.reader().terms("id_dv").iterator();
            SeekingTermSetTermsEnum termsEnum = new SeekingTermSetTermsEnum(ids, terms, terms.sort());
            Bits liveDocs = leaf.reader().getLiveDocs();
            BytesRef term = termsEnum.next();
            PostingsEnum postings = null;
            while (term != null) {
                postings = termsEnum.postings(postings, 0);
                int doc = postings.nextDoc();
                while (doc != Integer.MAX_VALUE && liveDocs != null && !liveDocs.get(doc)) {
                    doc = postings.nextDoc();
                }
                if (doc != Integer.MAX_VALUE) {
                    if (builder == null) {
                        builder = new DocIdSetBuilder(leaf.reader().maxDoc());
                    }
                    builder.grow(1).add(doc);
                    int globalDocId = doc + leaf.docBase;
                    nextCorrespondingResults.put(globalDocId, correspondingResults.get(term));
                }
                term = termsEnum.next();
            }
            if (builder == null) continue;
            nextDocs.put(leaf, builder.build().iterator());
        }
        return new JoinResult(nextDocs, nextCorrespondingResults);
    }

    private Map<Long, DocIdSet> _computeNumericMatches(Map<LeafReaderContext, DocIdSetIterator> docs, Map<Integer, DocIdSet> currentCorrespondingResults, String field) throws IOException {
        boolean multivalued = this.searcher.getSchema().getField(field).multiValued();
        HashMap<Long, DocIdSetBuilder> resultBuilders = new HashMap<Long, DocIdSetBuilder>();
        List leaves = this.searcher.getTopReaderContext().leaves();
        for (int subIndex = 0; subIndex < leaves.size(); ++subIndex) {
            SortedNumericDocValues docValues;
            LeafReaderContext leaf = (LeafReaderContext)leaves.get(subIndex);
            DocIdSetIterator docsIt = docs.get(leaf);
            if (docsIt == null) continue;
            SortedNumericDocValues sortedNumericDocValues = docValues = multivalued ? leaf.reader().getSortedNumericDocValues(field) : DocValues.singleton((NumericDocValues)leaf.reader().getNumericDocValues(field));
            if (docValues == null) continue;
            DocIdSetIterator it = ConjunctionUtils.createConjunction(List.of(docValues, docsIt), List.of());
            int docId = it.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                int globalDocId = docId + leaf.docBase;
                for (int i = 0; i < docValues.docValueCount(); ++i) {
                    long value = docValues.nextValue();
                    DocIdSetBuilder builder = resultBuilders.computeIfAbsent(value, __ -> new DocIdSetBuilder(this.searcher.maxDoc()));
                    builder.add(currentCorrespondingResults.get(globalDocId).iterator());
                }
                docId = it.nextDoc();
            }
        }
        HashMap<Long, DocIdSet> results = new HashMap<Long, DocIdSet>();
        Iterator iterator = resultBuilders.keySet().iterator();
        while (iterator.hasNext()) {
            long value = (Long)iterator.next();
            results.put(value, ((DocIdSetBuilder)resultBuilders.get(value)).build());
        }
        return results;
    }

    private NamedList<Integer> _count(Map<LeafReaderContext, DocIdSetIterator> docs, Map<Integer, DocIdSet> joinResults, String field) throws IOException {
        NumberType numberType = this.searcher.getSchema().getField(field).getType().getNumberType();
        if (numberType == null) {
            Matches matches = this._computeMatches(docs, joinResults, field, false);
            Map<BytesRef, DocIdSet> correspondingResults = matches.correspondingResults();
            SimpleOrderedMap joinCount = new SimpleOrderedMap();
            for (BytesRef term : correspondingResults.keySet()) {
                int count = 0;
                DocIdSetIterator involvedDocs = correspondingResults.get(term).iterator();
                while (involvedDocs.nextDoc() != Integer.MAX_VALUE) {
                    ++count;
                }
                joinCount.add(term.utf8ToString(), (Object)count);
            }
            return joinCount;
        }
        Map<Long, DocIdSet> correspondingResults = this._computeNumericMatches(docs, joinResults, field);
        SimpleOrderedMap joinCount = new SimpleOrderedMap();
        for (long value : correspondingResults.keySet()) {
            int count = 0;
            DocIdSetIterator involvedDocs = correspondingResults.get(value).iterator();
            while (involvedDocs.nextDoc() != Integer.MAX_VALUE) {
                ++count;
            }
            String actualValue = numberType == NumberType.DOUBLE ? String.valueOf(Double.longBitsToDouble(value)) : String.valueOf(value);
            joinCount.add(actualValue, (Object)count);
        }
        return joinCount;
    }

    private long _getGlobalOrd(long ord, int subIndex, OrdinalMap map) {
        if (map == null) {
            return ord;
        }
        LongValues ordMap = map.getGlobalOrds(subIndex);
        return ordMap.get(ord);
    }

    private record JoinResult(Map<LeafReaderContext, DocIdSetIterator> docs, Map<Integer, DocIdSet> correspondingResults) {
    }

    private record Matches(Map<BytesRef, DocIdSet> correspondingResults, BytesRefHash terms) {
    }

    private record GlobalOrdAndDocValues(OrdinalMap ordinalMap, SortedSetDocValues globalDocValues) {
    }
}

