/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.handler;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ametys.solr.helper.AclCacheManager;
import org.ametys.solr.helper.AllowedUsers;
import org.ametys.solr.helper.DebugMessageHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.Bits;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAclCacheHandler
extends RequestHandlerBase {
    public static final String ACL_ANONYMOUS = "anonymous";
    public static final String ACL_ANYCONNECTED = "anyConnectedUser";
    public static final String ACL_ALLOWED_USERS = "allowedUsers";
    public static final String ACL_DENIED_USERS = "deniedUsers";
    public static final String ACL_ALLOWED_GROUPS = "allowedGroups";
    public static final String ACL_DENIED_GROUPS = "deniedGroups";
    private static Logger __logger = LoggerFactory.getLogger(UpdateAclCacheHandler.class);
    private static final ConcurrentMap<String, Lock> __LOCKS_BY_CORE = new ConcurrentHashMap<String, Lock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        long start = System.currentTimeMillis();
        SolrCore core = req.getCore();
        String coreName = core.getName();
        SolrIndexSearcher searcher = req.getSearcher();
        String jsonStr = req.getParams().get("objects");
        JsonParser parser = new JsonFactory().createParser(jsonStr);
        Map contents = (Map)new ObjectMapper().readValue(parser, LinkedHashMap.class);
        Lock lock = UpdateAclCacheHandler.getLock(coreName);
        lock.lock();
        try {
            HashSet<String> handledObjects = new HashSet<String>();
            this._fill(coreName, searcher, contents, handledObjects);
            this._invalidateSolrCaches(coreName, searcher);
            Collection unHandledObjects = CollectionUtils.removeAll(contents.keySet(), handledObjects);
            if (unHandledObjects.isEmpty()) {
                rsp.add("result", (Object)"ok");
            } else {
                rsp.add("unhandled-objects", (Object)unHandledObjects);
            }
        }
        finally {
            lock.unlock();
        }
        __logger.debug("UpdateAclCacheHandler processed in {} ms", (Object)(System.currentTimeMillis() - start));
    }

    protected static Lock getLock(String coreName) {
        Lock lock = __LOCKS_BY_CORE.computeIfAbsent(coreName, n -> new ReentrantLock());
        return lock;
    }

    private void _fill(String coreName, SolrIndexSearcher searcher, Map<String, Map<String, Object>> contents, Set<String> handledContents) throws IOException {
        __logger.debug("Try to update ACL cache for core '{}' and several documents", (Object)coreName);
        Set<String> ids = contents.keySet();
        List leaves = searcher.getTopReaderContext().leaves();
        for (LeafReaderContext context : leaves) {
            LeafReader reader = context.reader();
            Bits liveDocs = reader.getLiveDocs();
            IndexReader.CacheKey segmentKey = reader.getCoreCacheHelper().getKey();
            if (AclCacheManager.getAllowedUsersInCache(searcher, segmentKey) == null) continue;
            for (String id : ids) {
                int doc;
                PostingsEnum postingsEnum;
                if (handledContents.contains(id) || (postingsEnum = reader.postings(new Term("id", id), 0)) == null) continue;
                while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    if (liveDocs != null && !liveDocs.get(doc)) continue;
                    String segmentName = DebugMessageHelper.segmentNameFromReader(reader, __logger);
                    __logger.debug("Found document for id {} in segment {}", (Object)id, (Object)segmentName);
                    Map<String, Object> content = contents.get(id);
                    AclCacheManager.putInCache(searcher, segmentKey, doc, this._getAllowedUsers(content));
                    AclCacheManager.removeBitSetsInCache(searcher, segmentKey);
                    handledContents.add(id);
                }
            }
        }
        __logger.debug("End updating ACL cache for core '{}' and several documents", (Object)coreName);
    }

    private AllowedUsers _getAllowedUsers(Map<String, Object> object) {
        return new AllowedUsers((Boolean)object.get(ACL_ANONYMOUS), (Boolean)object.get(ACL_ANYCONNECTED), (List)object.get(ACL_ALLOWED_USERS), (List)object.get(ACL_DENIED_USERS), (List)object.get(ACL_ALLOWED_GROUPS), (List)object.get(ACL_DENIED_GROUPS));
    }

    private void _invalidateSolrCaches(String coreName, SolrIndexSearcher searcher) {
        SolrInfoBean queryResultCache = (SolrInfoBean)searcher.getCore().getInfoRegistry().get("queryResultCache");
        if (queryResultCache != null && queryResultCache instanceof SolrCache) {
            ((SolrCache)queryResultCache).clear();
            __logger.debug("queryResultCache for core '{}' was cleared !", (Object)coreName);
        }
    }

    public String getDescription() {
        return "Update ACL Cache";
    }

    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }
}

