/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.helper;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.ametys.solr.helper.AllowedUsers;
import org.ametys.solr.helper.AmetysIOException;
import org.ametys.solr.helper.AmetysObjectDocumentInfo;
import org.ametys.solr.helper.AmetysReadAccessHelper;
import org.ametys.solr.helper.DebugMessageHelper;
import org.ametys.solr.helper.SegmentHelper;
import org.ametys.solr.helper.UserCacheKey;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AclCacheManager {
    public static final String CACHE_NAME = "aclCache";
    private static final String __CACHE_BISET_KEY = "bitSet";
    private static final String __CACHE_ALLOWEDUSERS_KEY = "allowedUsers";
    private static final Logger __LOGGER = LoggerFactory.getLogger(AclCacheManager.class);
    private static final ConcurrentMap<IndexReader.CacheKey, Lock> __ALLOWEDUSERS_LOCKS_BY_SEGMENT = new ConcurrentHashMap<IndexReader.CacheKey, Lock>();
    private static final ConcurrentMap<Pair<IndexReader.CacheKey, UserCacheKey>, Lock> __BITSET_LOCKS_BY_SEGMENT = new ConcurrentHashMap<Pair<IndexReader.CacheKey, UserCacheKey>, Lock>();

    private AclCacheManager() {
    }

    public static FixedBitSet getOrComputeBitSet(SolrIndexSearcher searcher, LeafReader reader, boolean anonymous, String population, String login, Set<String> groups, String ametysUrl) throws IOException, AmetysIOException {
        UserCacheKey userKey = AclCacheManager.userKeyForCache(anonymous, population, login, groups);
        IndexReader.CacheKey segmentKey = reader.getCoreCacheHelper().getKey();
        String segmentName = DebugMessageHelper.segmentNameFromReader(reader, __LOGGER);
        FixedBitSet bitSet = AclCacheManager._getBitSetInCache(searcher, segmentKey, userKey);
        if (bitSet != null) {
            __LOGGER.debug("Found in ACL cache for segment '{}' and user '{}'", (Object)segmentName, (Object)userKey);
        } else {
            __LOGGER.debug("Was not found in ACL BitSet cache for segment '{}' and user '{}'. It will now be computed from ACL AllowedUsers cache", (Object)segmentName, (Object)userKey);
            bitSet = AclCacheManager._computeBitSetAndPutInCache(reader, searcher, segmentKey, userKey, ametysUrl);
            if (bitSet != null) {
                __LOGGER.debug("Successfully computed the BitSet for segment '{}' and user '{}' from the ACL AllowedUsers cache", (Object)segmentName, (Object)userKey);
            } else {
                bitSet = new FixedBitSet(0);
                __LOGGER.error("An unexpected error occured, the BitSet object could not be retrieved from Ametys application for segment '{}' and user '{}'.", (Object)SegmentHelper.getSegmentReader(reader), (Object)userKey);
            }
        }
        return bitSet;
    }

    public static UserCacheKey userKeyForCache(boolean anonymous, String population, String login, Set<String> groups) {
        return anonymous ? UserCacheKey.ANONYMOUS_CACHE_KEY : new UserCacheKey(login, population, groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FixedBitSet _computeBitSetAndPutInCache(LeafReader reader, SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey, UserCacheKey userKey, String ametysUrl) throws IOException, AmetysIOException {
        FixedBitSet bitSet;
        Map<Integer, AllowedUsers> allowedUsersByDocIndex = AclCacheManager.getOrComputeAllowedUsers(reader, searcher, segmentKey, ametysUrl);
        if (allowedUsersByDocIndex == null) {
            __LOGGER.error("An unexpected error occured, allowed users could not be retrieved from Ametys application for segment '{}'.", (Object)SegmentHelper.getSegmentReader(reader));
            return null;
        }
        Lock writeLock = AclCacheManager.getBitSetLock(segmentKey, userKey);
        String segmentName = DebugMessageHelper.segmentNameFromReader(reader, __LOGGER);
        if (writeLock.tryLock()) {
            try {
                AclCacheManager._removeBitSetInCache(searcher, segmentKey, userKey);
                __LOGGER.debug("This thread will effectively compute BitSet for segment '{}' and user '{}'...", (Object)segmentName, (Object)userKey);
                bitSet = new FixedBitSet(reader.maxDoc());
                for (Integer docIndex : allowedUsersByDocIndex.keySet()) {
                    AllowedUsers allowedUsers = allowedUsersByDocIndex.get(docIndex);
                    boolean allowed = AclCacheManager._isUserAllowed(userKey, allowedUsers);
                    if (!allowed) continue;
                    bitSet.set(docIndex.intValue());
                }
                AclCacheManager._removeSameUserIgnoringGroupsInCache(searcher, segmentKey, userKey);
                AclCacheManager.putInCache(searcher, segmentKey, userKey, bitSet);
                __LOGGER.debug("This thread has finished to effectively compute BitSet for segment '{}' and user '{}'...", (Object)segmentName, (Object)userKey);
            }
            finally {
                writeLock.unlock();
            }
        }
        __LOGGER.debug("Waiting for another thread ({}) to finish to compute BitSet for segment '{}' and user '{}'...", new Object[]{writeLock, segmentName, userKey});
        writeLock.lock();
        try {
            bitSet = AclCacheManager._getBitSetInCache(searcher, segmentKey, userKey);
        }
        finally {
            writeLock.unlock();
        }
        __LOGGER.debug("The other thread has finished to compute BitSet for segment '{}' and user '{}'...", (Object)segmentName, (Object)userKey);
        return bitSet;
    }

    public static Map<Integer, AllowedUsers> getOrComputeAllowedUsers(LeafReader reader, SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey, String ametysUrl) throws IOException, AmetysIOException {
        Map<Integer, AllowedUsers> allowedUsersByDocIndex = AclCacheManager.getAllowedUsersInCache(searcher, segmentKey);
        if (allowedUsersByDocIndex == null) {
            String coreName = searcher.getCore().getName();
            AclCacheManager.computeAllowedUsers(reader, searcher, segmentKey, ametysUrl, coreName);
            allowedUsersByDocIndex = AclCacheManager.getAllowedUsersInCache(searcher, segmentKey);
        }
        return allowedUsersByDocIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void computeAllowedUsers(LeafReader reader, SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey, String ametysUrl, String coreName) throws IOException, AmetysIOException {
        Lock writeLock = AclCacheManager.getAllowedUsersLock(segmentKey);
        String segmentName = DebugMessageHelper.segmentNameFromReader(reader, __LOGGER);
        if (writeLock.tryLock()) {
            try {
                Map<String, Object> values = AclCacheManager._cacheUnderSegmentKey(searcher, segmentKey);
                values.remove(__CACHE_ALLOWEDUSERS_KEY);
                values.remove(__CACHE_BISET_KEY);
                __LOGGER.debug("This thread will effectively compute AllowedUsers object for segment '{}'...", (Object)segmentName);
                SortedDocValues idValues = reader.getSortedDocValues("id_dv");
                List<AmetysObjectDocumentInfo> ametysObjectDocuments = AclCacheManager.getDocuments(reader, idValues);
                Map<String, Integer> documentsMap = ametysObjectDocuments.stream().collect(Collectors.toMap(AmetysObjectDocumentInfo::getId, AmetysObjectDocumentInfo::getIndex));
                Map<String, AllowedUsers> response = AmetysReadAccessHelper.readAccessForDocuments(ametysUrl, coreName, ametysObjectDocuments, segmentName);
                if (response.isEmpty()) {
                    AclCacheManager._getAllowedUsersByDocIndexInCache(searcher, segmentKey);
                } else {
                    AclCacheManager._processAmetysResponse(response, searcher, segmentKey, documentsMap);
                }
                __LOGGER.debug("This thread has finished to effectively compute AllowedUsers object for segment '{}'...", (Object)segmentName);
            }
            finally {
                writeLock.unlock();
            }
        } else {
            __LOGGER.debug("Waiting for another thread ({}) to finish to compute AllowedUsers object for segment '{}'...", (Object)writeLock, (Object)segmentName);
            writeLock.lock();
            writeLock.unlock();
            __LOGGER.debug("The other thread has finished to compute AllowedUsers object for segment '{}'...", (Object)segmentName);
        }
    }

    private static void _processAmetysResponse(Map<String, AllowedUsers> response, SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey, Map<String, Integer> documentsMap) {
        for (String ametysObjectId : response.keySet()) {
            int docIndex = documentsMap.get(ametysObjectId);
            AllowedUsers allowedUsers = response.get(ametysObjectId);
            AclCacheManager.putInCache(searcher, segmentKey, docIndex, allowedUsers);
        }
    }

    private static boolean _isUserAllowed(UserCacheKey userKey, AllowedUsers allowedUsersObj) {
        String loginAndPopulation = userKey.getLoginAndPopulation();
        Set<String> groupKeys = userKey.getGroups();
        if (allowedUsersObj.isAnonymousAllowed()) {
            return true;
        }
        if (UserCacheKey.ANONYMOUS_CACHE_KEY == userKey) {
            return false;
        }
        if (allowedUsersObj.isAnyConnectedUserAllowed()) {
            List<String> deniedGroups = allowedUsersObj.getDeniedGroups();
            List<String> allowedUsers = allowedUsersObj.getAllowedUsers();
            List<String> deniedUsers = allowedUsersObj.getDeniedUsers();
            boolean isUserDenied = deniedUsers.contains(loginAndPopulation) || CollectionUtils.containsAny(deniedGroups, groupKeys) && !allowedUsers.contains(loginAndPopulation);
            return !isUserDenied;
        }
        List<String> allowedGroups = allowedUsersObj.getAllowedGroups();
        List<String> deniedGroups = allowedUsersObj.getDeniedGroups();
        List<String> allowedUsers = allowedUsersObj.getAllowedUsers();
        List<String> deniedUsers = allowedUsersObj.getDeniedUsers();
        return allowedUsers.contains(loginAndPopulation) && !deniedUsers.contains(loginAndPopulation) || CollectionUtils.containsAny(allowedGroups, groupKeys) && !CollectionUtils.containsAny(deniedGroups, groupKeys) && !deniedUsers.contains(loginAndPopulation);
    }

    public static List<AmetysObjectDocumentInfo> getDocuments(LeafReader reader, SortedDocValues idValues) throws IOException {
        ArrayList<AmetysObjectDocumentInfo> result = new ArrayList<AmetysObjectDocumentInfo>();
        PostingsEnum postings = reader.postings(new Term("ametysObject", "T"), 0);
        if (idValues == null || postings == null) {
            return result;
        }
        Bits liveDocs = reader.getLiveDocs();
        int index = postings.nextDoc();
        while (index != Integer.MAX_VALUE) {
            if ((liveDocs == null || liveDocs.get(index)) && idValues.advanceExact(index)) {
                String id = idValues.lookupOrd(idValues.ordValue()).utf8ToString();
                result.add(new AmetysObjectDocumentInfo(id, index));
            }
            index = postings.nextDoc();
        }
        return result;
    }

    protected static FixedBitSet _getBitSetInCache(SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey, UserCacheKey userKey) {
        Map<String, Object> values = AclCacheManager._cacheUnderSegmentKey(searcher, segmentKey);
        Map cacheByUser = (Map)values.get(__CACHE_BISET_KEY);
        if (cacheByUser == null) {
            return null;
        }
        return (FixedBitSet)cacheByUser.get(userKey);
    }

    public static Map<Integer, AllowedUsers> getAllowedUsersInCache(SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey) {
        Map<String, Object> values = AclCacheManager._cacheUnderSegmentKey(searcher, segmentKey);
        Map cacheByDocIndex = (Map)values.get(__CACHE_ALLOWEDUSERS_KEY);
        return cacheByDocIndex;
    }

    public static void putInCache(SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey, UserCacheKey userKey, FixedBitSet bitSet) {
        Map<String, Object> values = AclCacheManager._cacheUnderSegmentKey(searcher, segmentKey);
        Map cacheByUser = (Map)values.computeIfAbsent(__CACHE_BISET_KEY, k -> new ConcurrentHashMap());
        cacheByUser.put(userKey, bitSet);
    }

    public static void removeBitSetsInCache(SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey) {
        Map<String, Object> values = AclCacheManager._cacheUnderSegmentKey(searcher, segmentKey);
        values.remove(__CACHE_BISET_KEY);
    }

    private static void _removeBitSetInCache(SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey, UserCacheKey userKey) {
        Map<String, Object> values = AclCacheManager._cacheUnderSegmentKey(searcher, segmentKey);
        Map cacheByUser = (Map)values.get(__CACHE_BISET_KEY);
        if (cacheByUser != null) {
            cacheByUser.remove(userKey);
        }
    }

    private static synchronized void _removeSameUserIgnoringGroupsInCache(SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey, UserCacheKey userKey) {
        Map<String, Object> values = AclCacheManager._cacheUnderSegmentKey(searcher, segmentKey);
        Map cacheByUser = (Map)values.get(__CACHE_BISET_KEY);
        if (cacheByUser != null) {
            Iterator it = cacheByUser.keySet().iterator();
            while (it.hasNext()) {
                UserCacheKey userKeyInCache = (UserCacheKey)it.next();
                if (!userKey.hasSameLoginAndPopulation(userKeyInCache)) continue;
                it.remove();
            }
        }
    }

    public static void putNoAllowedUserInCache(SolrIndexSearcher searcher) {
        List leaves = searcher.getTopReaderContext().leaves();
        for (LeafReaderContext context : leaves) {
            LeafReader reader = context.reader();
            IndexReader.CacheKey segmentKey = reader.getCoreCacheHelper().getKey();
            Map<String, Object> values = AclCacheManager._cacheUnderSegmentKey(searcher, segmentKey);
            values.put(__CACHE_ALLOWEDUSERS_KEY, new ConcurrentHashMap());
        }
    }

    public static void putInCache(SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey, Integer docIndex, AllowedUsers allowedUsers) {
        Map<Integer, AllowedUsers> cacheByDocIndex = AclCacheManager._getAllowedUsersByDocIndexInCache(searcher, segmentKey);
        cacheByDocIndex.put(docIndex, allowedUsers);
    }

    private static Map<Integer, AllowedUsers> _getAllowedUsersByDocIndexInCache(SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey) {
        Map<String, Object> values = AclCacheManager._cacheUnderSegmentKey(searcher, segmentKey);
        Map cacheByDocIndex = (Map)values.computeIfAbsent(__CACHE_ALLOWEDUSERS_KEY, k -> new ConcurrentHashMap());
        return cacheByDocIndex;
    }

    private static Map<String, Object> _cacheUnderSegmentKey(SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey) {
        try {
            return (Map)searcher.getCache(CACHE_NAME).computeIfAbsent((Object)segmentKey, k -> new ConcurrentHashMap());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create the cache entry for key " + String.valueOf(segmentKey), e);
        }
    }

    protected static Lock getAllowedUsersLock(IndexReader.CacheKey segmentKey) {
        Lock lock = __ALLOWEDUSERS_LOCKS_BY_SEGMENT.computeIfAbsent(segmentKey, sk -> new ReentrantLock());
        return lock;
    }

    public static void removeAllowedUsersLock(IndexReader.CacheKey segmentKey) {
        __ALLOWEDUSERS_LOCKS_BY_SEGMENT.remove(segmentKey);
    }

    protected static Lock getBitSetLock(IndexReader.CacheKey segmentKey, UserCacheKey userKey) {
        Pair<IndexReader.CacheKey, UserCacheKey> segmentUserPair = new Pair<IndexReader.CacheKey, UserCacheKey>(segmentKey, userKey);
        Lock lock = __BITSET_LOCKS_BY_SEGMENT.computeIfAbsent(segmentUserPair, sup -> new ReentrantLock());
        return lock;
    }

    public static void removeBitSetLocks(IndexReader.CacheKey segmentKey) {
        for (Pair segmentUserPair : __BITSET_LOCKS_BY_SEGMENT.keySet()) {
            if (!segmentKey.equals(segmentUserPair.getLeftEl())) continue;
            __BITSET_LOCKS_BY_SEGMENT.remove(segmentUserPair);
        }
    }

    private static final class Pair<A, B>
    extends AbstractMap.SimpleEntry<A, B> {
        public Pair(A a, B b) {
            super(a, b);
        }

        public A getLeftEl() {
            return (A)this.getKey();
        }

        public B getRightEl() {
            return (B)this.getValue();
        }

        @Override
        public String toString() {
            return "Pair<" + String.valueOf(this.getKey()) + ", " + String.valueOf(this.getValue()) + ">";
        }
    }
}

