/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.helper;

import java.util.List;
import java.util.Objects;
import org.ametys.solr.helper.JoinParamParser;
import org.ametys.solr.plugins.ametys.AmetysQParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SyntaxError;

public final class JoinHelper {
    public static final String JOIN_FIELD_SUFFIX = "_s_dv";
    public static final String JOIN_FIELD_SEPARATOR = "%";

    private JoinHelper() {
    }

    public static AmetysQParser.JoinKey[] getFinalKeys(String join, SolrQueryRequest request, Query subQuery) throws SyntaxError {
        Query lastQuery;
        JoinParamParser joinParser = new JoinParamParser(join);
        joinParser.parse();
        AmetysQParser.JoinKey[] keys = joinParser.collect(request);
        Query lastNestedQuery = keys[keys.length - 1].nestedQuery();
        if (!(lastNestedQuery instanceof MatchAllDocsQuery) && subQuery != null) {
            throw new SyntaxError("The last member of the join path cannot have a nested query if the q parameter is present");
        }
        Query query = lastQuery = lastNestedQuery instanceof MatchAllDocsQuery ? subQuery : lastNestedQuery;
        if (lastQuery == null) {
            lastQuery = new MatchAllDocsQuery();
        }
        AmetysQParser.JoinKey lastKey = keys[keys.length - 1];
        keys[keys.length - 1] = new AmetysQParser.JoinKey(lastKey.key(), lastKey.joinField(), lastQuery);
        return keys;
    }

    public static String[] getFinalKeys(String join) throws SyntaxError {
        JoinParamParser joinParser = new JoinParamParser(join);
        joinParser.parse();
        List<String> joinParts = joinParser.collectJoinParts(true, true);
        if (joinParser.collectNestedQueries().stream().anyMatch(Objects::nonNull)) {
            throw new SyntaxError("No nested query is allowed in the join path '" + join + "'");
        }
        return joinParts.toArray(new String[joinParts.size()]);
    }
}

