/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.helper;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class UserCacheKey {
    public static final UserCacheKey ANONYMOUS_CACHE_KEY = new UserCacheKey("anonymous", null, Collections.emptySet());
    private final String _login;
    private final String _populationId;
    private final Set<String> _groups;

    public UserCacheKey(String login, String populationId, Set<String> groups) {
        Objects.requireNonNull(login, "login cannot be null");
        this._login = login;
        this._populationId = populationId;
        this._groups = groups;
    }

    public String getLoginAndPopulation() {
        return this._populationId == null ? this._login : this._login + "#" + this._populationId;
    }

    public Set<String> getGroups() {
        return this._groups;
    }

    public boolean hasSameLoginAndPopulation(UserCacheKey other) {
        return this._login.equals(other._login) && StringUtils.equals((CharSequence)this._populationId, (CharSequence)other._populationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("User<");
        sb.append(this.getLoginAndPopulation());
        if (CollectionUtils.isNotEmpty(this._groups)) {
            sb.append(", groups=" + String.valueOf(this.getGroups()));
        }
        sb.append(">");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._groups == null ? 0 : this._groups.hashCode());
        result = 31 * result + (this._login == null ? 0 : this._login.hashCode());
        result = 31 * result + (this._populationId == null ? 0 : this._populationId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserCacheKey)) {
            return false;
        }
        UserCacheKey other = (UserCacheKey)obj;
        if (this._groups == null ? other._groups != null : !this._groups.equals(other._groups)) {
            return false;
        }
        if (this._login == null ? other._login != null : !this._login.equals(other._login)) {
            return false;
        }
        return !(this._populationId == null ? other._populationId != null : !this._populationId.equals(other._populationId));
    }
}

