/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.plugins.acl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.solr.helper.AclCacheManager;
import org.ametys.solr.helper.AllowedUsers;
import org.ametys.solr.helper.DebugMessageHelper;
import org.ametys.solr.helper.SegmentHelper;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.core.AbstractSolrEventListener;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclCacheListener
extends AbstractSolrEventListener {
    public static final String ACL_INIT_VALUE_ANONYMOUS = "__initValueAclAnonymous";
    public static final String ACL_INIT_VALUE_ANYCONNECTED = "__initValueAclAnyConnectedUser";
    public static final String ACL_INIT_VALUE_ALLOWED_USERS = "__initValueAclAllowedUsers";
    public static final String ACL_INIT_VALUE_DENIED_USERS = "__initValueAclDeniedUsers";
    public static final String ACL_INIT_VALUE_ALLOWED_GROUPS = "__initValueAclAllowedGroups";
    public static final String ACL_INIT_VALUE_DENIED_GROUPS = "__initValueAclDeniedGroups";
    private static final Set<String> __ACL_INIT_VALUES = Stream.of("__initValueAclAnonymous", "__initValueAclAnyConnectedUser", "__initValueAclAllowedUsers", "__initValueAclDeniedUsers", "__initValueAclAllowedGroups", "__initValueAclDeniedGroups").collect(Collectors.toSet());
    private static final Logger __LOGGER = LoggerFactory.getLogger(AclCacheListener.class);

    public AclCacheListener(SolrCore core) {
        super(core);
    }

    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher oldSearcher) {
        __LOGGER.info("Regenerating ACL Cache for new searcher");
        ArrayList<IndexReader.CacheKey> oldSegments = new ArrayList<IndexReader.CacheKey>();
        HashMap<String, LeafReaderContext> oldSegmentsByName = new HashMap<String, LeafReaderContext>();
        for (LeafReaderContext context : oldSearcher.getTopReaderContext().leaves()) {
            oldSegments.add(context.reader().getCoreCacheHelper().getKey());
            oldSegmentsByName.put(SegmentHelper.segmentNameFromReader(context.reader()), context);
        }
        Map newSegments = newSearcher.getTopReaderContext().leaves().stream().collect(Collectors.toMap(c -> c.reader().getCoreCacheHelper().getKey(), Function.identity()));
        for (IndexReader.CacheKey key : oldSegments) {
            if (newSegments.containsKey(key)) {
                LeafReaderContext stillExistingSegment = (LeafReaderContext)newSegments.get(key);
                String segmentName = DebugMessageHelper.segmentNameFromReader(stillExistingSegment.reader(), __LOGGER);
                __LOGGER.info("Segment '{}' still exists, it will be kept in ACL cache", (Object)segmentName);
                Object cachedAcl = oldSearcher.cacheLookup("aclCache", (Object)key);
                if (cachedAcl != null) {
                    newSearcher.cacheInsert("aclCache", (Object)key, cachedAcl);
                    __LOGGER.debug("    Cached values inserted for segment '{}'", (Object)segmentName);
                    continue;
                }
                __LOGGER.debug("    No cached values for segment '{}'", (Object)segmentName);
                continue;
            }
            __LOGGER.info("Segment '{}' does not exist anymore, it will be removed from ACL cache", (Object)key);
            AclCacheManager.removeAllowedUsersLock(key);
            AclCacheManager.removeBitSetLocks(key);
        }
        for (IndexReader.CacheKey key : newSegments.keySet()) {
            if (oldSegments.contains(key)) continue;
            this._preFillCache(newSearcher, oldSearcher, key, (LeafReaderContext)newSegments.get(key), oldSegmentsByName);
        }
    }

    private void _preFillCache(SolrIndexSearcher newSearcher, SolrIndexSearcher oldSearcher, IndexReader.CacheKey segmentKey, LeafReaderContext readerContext, Map<String, LeafReaderContext> oldSegmentsByName) {
        LeafReader unwrappedLeafReader;
        LeafReader reader = readerContext.reader();
        String source = this._getSource(reader);
        if ("flush".equals(source)) {
            String segmentName = DebugMessageHelper.segmentNameFromReader(reader, __LOGGER);
            __LOGGER.info("Pre-filling AllowedUsers cache for flushed segment {}", (Object)segmentName);
            try {
                this._preFillCacheForFlushedSegment(reader, newSearcher, segmentKey);
            }
            catch (IOException e) {
                __LOGGER.warn("Caught exception while prefilling cache for flushed segment {}", (Object)segmentName, (Object)e);
            }
        } else if ("merge".equals(source) && (unwrappedLeafReader = FilterLeafReader.unwrap((LeafReader)reader)) instanceof SegmentReader) {
            SegmentReader segmentReader = (SegmentReader)unwrappedLeafReader;
            String segmentName = segmentReader.getSegmentName();
            String mergedSegments = (String)segmentReader.getSegmentInfo().info.getDiagnostics().get("mergedSegments");
            if (mergedSegments != null) {
                String[] mergedSegmentNames = mergedSegments.split(";");
                __LOGGER.info("Pre-filling AllowedUsers cache for segment {}, merged from {}", (Object)segmentName, (Object)mergedSegmentNames);
                try {
                    this._preFillCacheForMergedSegment(reader, newSearcher, oldSearcher, segmentKey, mergedSegmentNames, oldSegmentsByName);
                }
                catch (IOException e) {
                    __LOGGER.warn("Caught exception while prefilling cache for merged segment {}", (Object)segmentName, (Object)e);
                }
            } else {
                __LOGGER.info("No merge sources for segment {}, cannot pre-fill its ACL cache", (Object)segmentName);
            }
        }
    }

    private String _getSource(LeafReader leafReader) {
        String source = null;
        LeafReader unwrappedLeafReader = FilterLeafReader.unwrap((LeafReader)leafReader);
        if (unwrappedLeafReader instanceof SegmentReader) {
            SegmentReader segmentReader = (SegmentReader)unwrappedLeafReader;
            SegmentInfo segmentInfo = segmentReader.getSegmentInfo().info;
            source = (String)segmentInfo.getDiagnostics().get("source");
        }
        if (source == null) {
            __LOGGER.warn("Source of '{}' cannot be determined. Thus, pre-filling of ACL cache will not be made.", (Object)leafReader);
        }
        return source;
    }

    private void _preFillCacheForFlushedSegment(LeafReader reader, SolrIndexSearcher newSearcher, IndexReader.CacheKey segmentKey) throws IOException {
        PostingsEnum postings = reader.postings(new Term("ametysObject", "T"), 0);
        if (postings == null) {
            return;
        }
        Bits liveDocs = reader.getLiveDocs();
        int index = postings.nextDoc();
        while (index != Integer.MAX_VALUE) {
            if (liveDocs == null || liveDocs.get(index)) {
                Document document = reader.storedFields().document(index, __ACL_INIT_VALUES);
                AclCacheManager.putInCache(newSearcher, segmentKey, index, this._allowedUsers(document));
            }
            index = postings.nextDoc();
        }
    }

    private void _preFillCacheForMergedSegment(LeafReader reader, SolrIndexSearcher newSearcher, SolrIndexSearcher oldSearcher, IndexReader.CacheKey segmentKey, String[] mergedSegmentNames, Map<String, LeafReaderContext> oldSegmentsByName) throws IOException {
        LeafReader mergedReader;
        HashMap<String, Map<Integer, AllowedUsers>> oldCaches = new HashMap<String, Map<Integer, AllowedUsers>>();
        for (String mergedSegment : mergedSegmentNames) {
            LeafReaderContext oldContext = oldSegmentsByName.get(mergedSegment);
            if (oldContext == null) {
                __LOGGER.info("Segment {} not found in old searcher, possibly due to merge occuring during commit, pre-filling aborted ", (Object)mergedSegment);
                return;
            }
            mergedReader = oldContext.reader();
            Map<Integer, AllowedUsers> oldUserCache = AclCacheManager.getAllowedUsersInCache(oldSearcher, mergedReader.getCoreCacheHelper().getKey());
            if (oldUserCache == null) {
                __LOGGER.info("No cached values for segment {}, pre-filling aborted ", (Object)mergedSegment);
                return;
            }
            oldCaches.put(mergedSegment, oldUserCache);
        }
        TermsEnum termsEnum = reader.terms("id").iterator();
        for (String mergedSegment : mergedSegmentNames) {
            mergedReader = oldSegmentsByName.get(mergedSegment).reader();
            Bits liveDocs = mergedReader.getLiveDocs();
            SortedDocValues mergedIds = mergedReader.getSortedDocValues("id_dv");
            Map oldUserCache = (Map)oldCaches.get(mergedSegment);
            Iterator iterator = new TreeSet(oldUserCache.keySet()).iterator();
            while (iterator.hasNext()) {
                int doc = (Integer)iterator.next();
                if (liveDocs != null && !liveDocs.get(doc) || !mergedIds.advanceExact(doc)) continue;
                String id = mergedIds.lookupOrd(mergedIds.ordValue()).utf8ToString();
                if (termsEnum.seekExact(new BytesRef((CharSequence)id))) {
                    PostingsEnum postings = termsEnum.postings(null, 0);
                    int newDoc = postings.nextDoc();
                    AllowedUsers allowedUsers = (AllowedUsers)oldUserCache.get(doc);
                    AclCacheManager.putInCache(newSearcher, segmentKey, newDoc, allowedUsers);
                    __LOGGER.trace("Segment {}: {} id {} => {} : {}", new Object[]{mergedSegment, doc, id, newDoc, allowedUsers});
                    continue;
                }
                __LOGGER.trace("Segment {}: no correspondance for id {}, it should have been deleted ", (Object)mergedSegment, (Object)id);
            }
        }
    }

    private AllowedUsers _allowedUsers(Document doc) {
        return new AllowedUsers(this._isTrueField(ACL_INIT_VALUE_ANONYMOUS, doc), this._isTrueField(ACL_INIT_VALUE_ANYCONNECTED, doc), this._fieldValues(ACL_INIT_VALUE_ALLOWED_USERS, doc), this._fieldValues(ACL_INIT_VALUE_DENIED_USERS, doc), this._fieldValues(ACL_INIT_VALUE_ALLOWED_GROUPS, doc), this._fieldValues(ACL_INIT_VALUE_DENIED_GROUPS, doc));
    }

    private boolean _isTrueField(String name, Document doc) {
        return Optional.of(name).map(arg_0 -> ((Document)doc).getField(arg_0)).map(IndexableField::stringValue).map("T"::equals).orElse(false);
    }

    private List<String> _fieldValues(String name, Document doc) {
        return Stream.of(doc.getFields(name)).map(IndexableField::stringValue).collect(Collectors.toList());
    }
}

