/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.plugins.aclcompare;

import java.io.IOException;
import org.ametys.solr.helper.AllowedUsers;
import org.ametys.solr.plugins.AbstractAclBaseQuery;
import org.ametys.solr.plugins.aclcompare.AclCompareQueryWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexSearcher;

public class AclCompareQuery
extends AbstractAclBaseQuery {
    private SolrIndexSearcher _searcher;
    private String _ametysUrl;
    private AllowedUsers _allowedUsersToCompare;

    public AclCompareQuery(SolrIndexSearcher searcher, String ametysUrl, AllowedUsers allowedUsersToCompare) {
        this._searcher = searcher;
        this._ametysUrl = ametysUrl;
        this._allowedUsersToCompare = allowedUsersToCompare;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new AclCompareQueryWeight(this._searcher, this, this._ametysUrl, this._allowedUsersToCompare);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder("AclCompareQuery(");
        sb.append(this._allowedUsersToCompare).append(")");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._allowedUsersToCompare == null ? 0 : this._allowedUsersToCompare.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AclCompareQuery other = (AclCompareQuery)((Object)obj);
        return !(this._allowedUsersToCompare == null ? other._allowedUsersToCompare != null : !this._allowedUsersToCompare.equals(other._allowedUsersToCompare));
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }
}

