/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.plugins.aclcompare;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.solr.helper.AclCacheManager;
import org.ametys.solr.helper.AllowedUsers;
import org.ametys.solr.helper.AmetysIOException;
import org.ametys.solr.plugins.acl.AclQueryScorer;
import org.ametys.solr.plugins.acl.AclQueryWeight;
import org.ametys.solr.plugins.aclcompare.AclCompareQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.LoggerFactory;

public class AclCompareQueryWeight
extends Weight {
    private SolrIndexSearcher _searcher;
    private String _ametysUrl;
    private AllowedUsers _allowedUsersToCompare;

    public AclCompareQueryWeight(SolrIndexSearcher searcher, AclCompareQuery query, String ametysUrl, AllowedUsers allowedUsersToCompare) {
        super((Query)query);
        this._searcher = searcher;
        this._ametysUrl = ametysUrl;
        this._allowedUsersToCompare = allowedUsersToCompare;
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        Map<Integer, AllowedUsers> allowedUsersByDocIndex;
        LeafReader reader = context.reader();
        try {
            allowedUsersByDocIndex = AclCacheManager.getOrComputeAllowedUsers(reader, this._searcher, reader.getCoreCacheHelper().getKey(), this._ametysUrl);
        }
        catch (AmetysIOException e) {
            LoggerFactory.getLogger(AclQueryWeight.class).error("An error occured when communicating with Ametys application. The query could not be executed correctly. All contents will be marked as not allowed.", (Throwable)e);
            AclCacheManager.putNoAllowedUserInCache(this._searcher);
            return new AclQueryScorer(this, (DocIdSetIterator)new BitSetIterator((BitSet)new FixedBitSet(0), 1L));
        }
        FixedBitSet bitSet = this._computeBitSet(allowedUsersByDocIndex, reader);
        return new AclQueryScorer(this, (DocIdSetIterator)new BitSetIterator((BitSet)bitSet, 1L));
    }

    private FixedBitSet _computeBitSet(Map<Integer, AllowedUsers> allowedUsersByDocIndex, LeafReader reader) {
        FixedBitSet bitSet = new FixedBitSet(reader.maxDoc());
        for (Integer docIndex : allowedUsersByDocIndex.keySet()) {
            AllowedUsers documentAllowedUsers = allowedUsersByDocIndex.get(docIndex);
            if (!this._documentIsAllowed(documentAllowedUsers)) continue;
            bitSet.set(docIndex.intValue());
        }
        return bitSet;
    }

    private boolean _documentIsAllowed(AllowedUsers documentAllowedUsers) {
        if (documentAllowedUsers.isAnonymousAllowed()) {
            return true;
        }
        if (this._allowedUsersToCompare.isAnonymousAllowed() || this._allowedUsersToCompare.isAnyConnectedUserAllowed() && !documentAllowedUsers.isAnyConnectedUserAllowed()) {
            return false;
        }
        if (!this._allowedUsersToCompare.isAnyConnectedUserAllowed() && documentAllowedUsers.isAnyConnectedUserAllowed()) {
            return this._docIsAllowedWhenCompareIsNotAnyConnectedAndDocIsAnyConnected(documentAllowedUsers);
        }
        return documentAllowedUsers.getAllowedUsers().containsAll(this._allowedUsersToCompare.getAllowedUsers()) && this._allowedUsersToCompare.getDeniedUsers().containsAll(documentAllowedUsers.getDeniedUsers()) && documentAllowedUsers.getAllowedGroups().containsAll(this._allowedUsersToCompare.getAllowedGroups()) && this._allowedUsersToCompare.getDeniedGroups().containsAll(documentAllowedUsers.getDeniedGroups());
    }

    private boolean _docIsAllowedWhenCompareIsNotAnyConnectedAndDocIsAnyConnected(AllowedUsers documentAllowedUsers) {
        List<String> docDeniedUsers = documentAllowedUsers.getDeniedUsers();
        List<String> docDeniedGroups = documentAllowedUsers.getDeniedGroups();
        List<String> compAllowedUsers = this._allowedUsersToCompare.getAllowedUsers();
        List<String> compAllowedGroups = this._allowedUsersToCompare.getAllowedGroups();
        List<String> compDeniedGroups = this._allowedUsersToCompare.getDeniedGroups();
        if (!docDeniedGroups.isEmpty() && !docDeniedGroups.equals(compDeniedGroups)) {
            return false;
        }
        if (CollectionUtils.containsAny(compAllowedUsers, docDeniedUsers) || CollectionUtils.containsAny(compAllowedGroups, docDeniedGroups)) {
            return false;
        }
        return (compAllowedUsers.isEmpty() || docDeniedGroups.isEmpty()) && (compAllowedGroups.isEmpty() || docDeniedUsers.isEmpty());
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        Scorer scorer = this.scorer(context);
        if (scorer != null && scorer.iterator().advance(doc) == doc) {
            return Explanation.match((Number)Float.valueOf(scorer.score()), (String)"AclCompare match", (Explanation[])new Explanation[0]);
        }
        return Explanation.noMatch((String)"No AclCompare match", (Explanation[])new Explanation[0]);
    }
}

