/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.plugins.ametys;

import java.io.IOException;
import org.ametys.solr.helper.JoinHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.JoinUtil;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public class AmetysQParser
extends QParser {
    public static final String JOIN_PARAM = "join";
    public static final String QUERY_PARAM = "q";

    public AmetysQParser(String q, SolrParams localParameters, SolrParams parameters, SolrQueryRequest request) {
        super(q, localParameters, parameters, request);
    }

    public Query parse() throws SyntaxError {
        Query subQuery = this._subQuery();
        String joinParam = this.localParams.get(JOIN_PARAM);
        if (StringUtils.isEmpty((CharSequence)joinParam) && subQuery == null) {
            throw new SyntaxError("Both join and q parameters are not present.");
        }
        if (StringUtils.isEmpty((CharSequence)joinParam)) {
            return subQuery;
        }
        JoinKey[] joins = JoinHelper.getFinalKeys(joinParam, this.req, subQuery);
        try {
            Query result = null;
            for (int i = joins.length - 1; i >= 0; --i) {
                JoinKey join = joins[i];
                Query nestedQuery = join.nestedQuery();
                Object currentQuery = null;
                currentQuery = result == null ? nestedQuery : (nestedQuery instanceof MatchAllDocsQuery ? result : new BooleanQuery.Builder().add(result, BooleanClause.Occur.MUST).add(nestedQuery, BooleanClause.Occur.MUST).build());
                result = JoinUtil.createJoinQuery((String)join.joinField(), (boolean)true, (String)join.key(), (Query)currentQuery, (IndexSearcher)this.req.getSearcher(), (ScoreMode)ScoreMode.Avg);
            }
            return result;
        }
        catch (IOException e) {
            throw new SyntaxError("Unable to create Join Query", (Throwable)e);
        }
    }

    private Query _subQuery() throws SyntaxError {
        String queryString;
        String string = queryString = StringUtils.isNotEmpty((CharSequence)this.qstr) ? this.qstr : this.localParams.get(QUERY_PARAM);
        if (StringUtils.isNotEmpty((CharSequence)queryString)) {
            QParser subParser = this.subQuery(queryString, null);
            return subParser.getQuery();
        }
        return null;
    }

    public record JoinKey(String key, String joinField, Query nestedQuery) {
    }
}

