/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.plugins.fuzzy;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public class FuzzyQParser
extends QParser {
    public static final int MIN_TERM_LENGTH = 3;
    public static final int LOW_EDIT_THRESHOLD = 5;

    public FuzzyQParser(String q, SolrParams localParameters, SolrParams parameters, SolrQueryRequest request) {
        super(q, localParameters, parameters, request);
    }

    public Query parse() throws SyntaxError {
        Query q = this.subQuery(this.qstr, null).parse();
        return this._transform(q);
    }

    private Query _transform(Query q) {
        if (q instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)q;
            Term term = termQuery.getTerm();
            int termLength = term.text().length();
            if (termLength <= 3) {
                return q;
            }
            int maxEdits = termLength <= 5 ? 1 : 2;
            return new FuzzyQuery(term, maxEdits);
        }
        if (q instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)q;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            booleanQuery.clauses().stream().map(clause -> new BooleanClause(this._transform(clause.getQuery()), clause.getOccur())).forEach(arg_0 -> ((BooleanQuery.Builder)builder).add(arg_0));
            return builder.build();
        }
        return this.query;
    }
}

