/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.sort;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.ametys.solr.helper.JoinHelper;
import org.ametys.solr.sort.AbstractJoinComparator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DatePointField;
import org.apache.solr.schema.DoublePointField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatPointField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IntPointField;
import org.apache.solr.schema.LongPointField;
import org.apache.solr.schema.NumericFieldType;
import org.apache.solr.schema.SortableTextField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmetysFunction
extends ValueSource {
    private static final Class[] __VALID_TYPES = new Class[]{IntPointField.class, FloatPointField.class, LongPointField.class, DoublePointField.class, BoolField.class, DatePointField.class, TextField.class, StrField.class, SortableTextField.class};
    private static Logger __logger = LoggerFactory.getLogger(AmetysFunction.class);
    protected String _join;
    protected String _finalField;
    private SolrIndexSearcher _searcher;
    private IndexSchema _schema;
    private String[] _keys;

    public AmetysFunction(String join, String finalField, SolrIndexSearcher searcher, IndexSchema schema) {
        this._join = join;
        this._finalField = finalField;
        this._searcher = searcher;
        this._schema = schema;
        if (!this._isValidType()) {
            String msg = "The second argument of the join function is not a field with a valid type (" + this.getType().getTypeName() + ")";
            __logger.error(msg);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        try {
            this._keys = JoinHelper.getFinalKeys(this._join);
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not get final keys of join: " + this._join, (Throwable)e);
        }
    }

    private boolean _isValidType() {
        return ArrayUtils.contains((Object[])__VALID_TYPES, this.getType().getClass());
    }

    public FieldType getType() {
        return this._schema.getFieldType(this._finalField);
    }

    public SortField getSortField(boolean reverse) {
        return new SortField(this._finalField, (FieldComparatorSource)new AmetysComparatorSource(), reverse);
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        throw new UnsupportedOperationException("AmetysFunction does not export values");
    }

    public String description() {
        return "AmetysFunction(join=\"" + this._join + "\", finalField=\"" + this._finalField + "\")";
    }

    public int hashCode() {
        return Objects.hash(this._join, this._finalField);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AmetysFunction)) {
            return false;
        }
        AmetysFunction function = (AmetysFunction)((Object)obj);
        return Objects.equals(this._join, function._join) && Objects.equals(this._finalField, function._finalField);
    }

    class AmetysComparatorSource
    extends FieldComparatorSource {
        AmetysComparatorSource() {
        }

        public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
            FieldType fieldType = AmetysFunction.this.getType();
            if (fieldType instanceof TextField || fieldType instanceof StrField) {
                return new AbstractJoinComparator.StringJoinComparator(numHits, AmetysFunction.this._schema, AmetysFunction.this._searcher, AmetysFunction.this._keys, AmetysFunction.this._finalField, reversed);
            }
            if (fieldType instanceof BoolField) {
                return new AbstractJoinComparator.BoolJoinComparator(numHits, AmetysFunction.this._schema, AmetysFunction.this._searcher, AmetysFunction.this._keys, AmetysFunction.this._finalField, reversed);
            }
            if (fieldType instanceof NumericFieldType) {
                return new AbstractJoinComparator.NumericJoinComparator(numHits, AmetysFunction.this._schema, AmetysFunction.this._searcher, AmetysFunction.this._keys, AmetysFunction.this._finalField, reversed);
            }
            throw new IllegalArgumentException("Invalid type for field " + AmetysFunction.this._finalField);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AmetysComparatorSource)) {
                return false;
            }
            AmetysComparatorSource source = (AmetysComparatorSource)((Object)obj);
            return source.hashCode() == this.hashCode();
        }

        public int hashCode() {
            return 31 * Arrays.hashCode(AmetysFunction.this._keys) + AmetysFunction.this._finalField.hashCode();
        }
    }
}

