/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.sort;

import org.ametys.solr.sort.AmetysFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmetysValueSourceParser
extends ValueSourceParser {
    private static Logger __logger = LoggerFactory.getLogger(AmetysValueSourceParser.class);

    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        String join = fp.parseArg();
        String finalField = fp.parseArg();
        if (StringUtils.isBlank((CharSequence)join) || StringUtils.isBlank((CharSequence)finalField) || fp.parseArg() != null) {
            String msg = "The ametys function must have two parameters";
            __logger.error(msg);
            throw new SyntaxError(msg);
        }
        SolrQueryRequest req = fp.getReq();
        return new AmetysFunction(join, finalField, req.getSearcher(), req.getSchema());
    }
}

