/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.web.test.framework;

import org.ametys.runtime.test.framework.CocoonTestCase;
import org.ametys.runtime.test.framework.CocoonTestCase.NeedFeatures;
import org.ametys.runtime.test.framework.TestConfigSet;

/**
 * Marker interface in order to {@link NeedFeatures load} features needed by a WEB application.
 */
@NeedFeatures({
    "web/init", // init for WEB
    
    "cms/content-attribute-type.dependencies", // for extensions of ContentAttributeTypeExtensionPoint (automatically initialized) (HTMLRichTextContentElementType...)
    "cms/content-type-descriptor.dependencies", // for extensions of DynamicContentTypeDescriptorExtentionPoint (automatically initialized) (DynamicContentTypeDescriptor, AbstractContentTypeDescriptor, DefaultContentType...)
    "web/web.service.parameter.types", // for extensions of ServiceParameterTypeExtensionPoint
    "web/web.repository.site.parameter.types", // for extensions of SiteParameterTypeExtensionPoint
    
    "web/sitetype.default", // for site type 'default'
    
    "web/administration.skins.actions", // for skins
    
    "web/gdpr.component.helper", // for gdpr
    
    "core-ui/org.ametys.runtime.log.memoryAppender" // for AddTaskclientSideElement
})
public interface WithWebFeaturesTestCase extends CocoonTestCase
//extends WithCmsFeaturesTestCase: NO, it should not extends WithCmsFeaturesTestCase, in order to avoid problem due to features deactivated by plugin web (such as cms/cms.init etc.)
{
    @Override
    default TestConfigSet getConfigSet()
    {
        return CocoonTestCase.super.getConfigSet()
                .withConfigFile("test/environments/config.xml")
                .withWebappPath("test/environments/webapp");
    }
}
