/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.AbstractWorkflow;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.store.AmetysStep;
import org.ametys.plugins.workflow.store.AmetysWorkflowStore;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAmetysWorkflow
extends AbstractWorkflow {
    protected static Logger _logger = LoggerFactory.getLogger(AbstractAmetysWorkflow.class);
    protected Map<Long, ReentrantLock> _instancesLocks = new HashMap<Long, ReentrantLock>();
    protected WorkflowHelper _workflowHelper;

    protected AbstractAmetysWorkflow(WorkflowHelper workflowHelper, WorkflowContext workflowContext) {
        this._workflowHelper = workflowHelper;
        this.context = workflowContext;
        this._instancesLocks = new HashMap<Long, ReentrantLock>();
    }

    public long initialize(String workflowName, int initialActionId, Map inputs) throws WorkflowException {
        HashMap initInputs;
        int actionId = initialActionId;
        if (initialActionId == Integer.MIN_VALUE) {
            actionId = this._workflowHelper.getInitialAction(workflowName);
        }
        if ((initInputs = inputs) == null) {
            initInputs = new HashMap();
        }
        if (!initInputs.containsKey(AbstractWorkflowComponent.RESULT_MAP_KEY)) {
            initInputs.put(AbstractWorkflowComponent.RESULT_MAP_KEY, new LinkedHashMap());
        }
        return super.initialize(workflowName, actionId, initInputs);
    }

    public int[] getAvailableActions(long id, Map inputs) {
        HashMap doInputs = inputs;
        if (doInputs == null) {
            doInputs = new HashMap();
        }
        if (!doInputs.containsKey(AbstractWorkflowComponent.RESULT_MAP_KEY)) {
            doInputs.put(AbstractWorkflowComponent.RESULT_MAP_KEY, new LinkedHashMap());
        }
        return super.getAvailableActions(id, inputs);
    }

    @Deprecated
    public int[] getAvailableActions(long id) {
        HashMap inputs = new HashMap();
        inputs.put(AbstractWorkflowComponent.RESULT_MAP_KEY, new LinkedHashMap());
        return super.getAvailableActions(id, inputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(long id, int actionId, Map inputs) throws WorkflowException {
        ReentrantLock instanceLock = null;
        Map<Long, ReentrantLock> map = this._instancesLocks;
        synchronized (map) {
            instanceLock = this._instancesLocks.get(id);
            if (instanceLock == null) {
                instanceLock = new ReentrantLock(true);
                this._instancesLocks.put(id, instanceLock);
            }
        }
        try {
            HashMap doInputs = inputs;
            if (doInputs == null) {
                doInputs = new HashMap();
            }
            if (!doInputs.containsKey(AbstractWorkflowComponent.RESULT_MAP_KEY)) {
                doInputs.put(AbstractWorkflowComponent.RESULT_MAP_KEY, new LinkedHashMap());
            }
            instanceLock.lock();
            super.doAction(id, actionId, doInputs);
        }
        finally {
            instanceLock.unlock();
        }
        if (this.getEntryState(id) == 4) {
            try {
                WorkflowStore store = this.getConfiguration().getWorkflowStore();
                if (store instanceof AmetysWorkflowStore && ((AmetysWorkflowStore)store).shouldClearHistory()) {
                    ((AmetysWorkflowStore)store).deleteInstance(id);
                }
            }
            catch (StoreException e) {
                _logger.error("Error while getting the workflow store", (Throwable)e);
            }
        }
    }

    protected boolean transitionWorkflow(WorkflowEntry entry, List currentSteps, WorkflowStore store, WorkflowDescriptor wf, ActionDescriptor action, Map transientVars, Map inputs, PropertySet ps) throws WorkflowException {
        AmetysStep theStep;
        Date actionStartDate = new Date();
        for (Object step : currentSteps) {
            if (!(step instanceof AmetysStep)) continue;
            theStep = (AmetysStep)step;
            theStep.setProperty("actionStartDate", actionStartDate);
            theStep.save();
        }
        boolean complete = super.transitionWorkflow(entry, currentSteps, store, wf, action, transientVars, inputs, ps);
        Step createdStep = (Step)transientVars.get("createdStep");
        if (createdStep != null && createdStep instanceof AmetysStep) {
            theStep = (AmetysStep)createdStep;
            theStep.setProperty("actionFinishDate", new Date());
            theStep.save();
        }
        return complete;
    }

    protected void checkImplicitFinish(ActionDescriptor action, long id) throws WorkflowException {
    }
}

