/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.cocoon;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.component.CheckRightsCondition;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractWorkflowAction
extends ServiceableAction
implements Initializable {
    protected WorkflowProvider _workflowProvider;

    public void initialize() throws Exception {
        this._workflowProvider = (WorkflowProvider)this.manager.lookup(WorkflowProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        int actionId = this._getActionId(objectModel, source, parameters);
        Map<String, Object> inputs = this._getInputs(redirector, objectModel, source, parameters);
        try {
            Map result = this._act(redirector, objectModel, source, parameters, actionId, inputs);
            Map resultMap = (Map)inputs.get(AbstractWorkflowComponent.RESULT_MAP_KEY);
            resultMap.put("success", true);
            return result;
        }
        catch (InvalidActionException e) {
            return this._processInvalidActionException(redirector, objectModel, source, parameters, actionId, inputs, e);
        }
        catch (WorkflowException e) {
            return this._processWorkflowException(redirector, objectModel, source, parameters, actionId, e);
        }
    }

    protected int _getActionId(Map objectModel, String source, Parameters parameters) throws Exception {
        return parameters.getParameterAsInteger("actionId", Integer.MIN_VALUE);
    }

    protected Map<String, Object> _getInputs(Redirector redirector, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY, objectModel.get("parent-context"));
        inputs.put(AbstractWorkflowComponent.FAIL_CONDITIONS_KEY, new ArrayList());
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (request.getAttribute("Runtime:InternalAllowedRequest") != null) {
            inputs.put(CheckRightsCondition.FORCE, true);
        }
        LinkedHashMap result = new LinkedHashMap();
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        inputs.put(AbstractWorkflowComponent.RESULT_MAP_KEY, result);
        return inputs;
    }

    protected abstract Map _act(Redirector var1, Map var2, String var3, Parameters var4, int var5, Map var6) throws InvalidInputException, WorkflowException;

    protected Map _processInvalidActionException(Redirector redirector, Map objectModel, String source, Parameters parameters, long actionId, Map inputs, InvalidActionException e) throws Exception {
        if (this._getWorkflowErrors(inputs) != null) {
            this.getLogger().error(String.format("Invalid action: '%d' for %s. %s", actionId, this._getExceptionContext(objectModel, source, parameters), this._getFailConditions(inputs)), (Throwable)e);
            return Collections.EMPTY_MAP;
        }
        throw new Exception(String.format("Invalid action: '%d' for %s. %s", actionId, this._getExceptionContext(objectModel, source, parameters), this._getFailConditions(inputs)), e);
    }

    protected String _getFailConditions(Map inputs) {
        List failConditions;
        if (inputs.containsKey(AbstractWorkflowComponent.FAIL_CONDITIONS_KEY) && (failConditions = (List)inputs.get(AbstractWorkflowComponent.FAIL_CONDITIONS_KEY)).size() > 0) {
            return String.format("Fail conditions are: %s", StringUtils.join(failConditions.stream().map(AbstractWorkflowComponent.ConditionFailure::text).toList(), (String)" / "));
        }
        return "";
    }

    protected List<I18nizableText> _getWorkflowErrors(Map inputs) {
        Map result = (Map)inputs.get(AbstractWorkflowComponent.RESULT_MAP_KEY);
        if (result.containsKey("workflowValidation")) {
            return ((ValidationResult)result.get("workflowValidation")).getErrors();
        }
        return null;
    }

    protected List<I18nizableText> _getWorkflowWarns(Map inputs) {
        Map result = (Map)inputs.get(AbstractWorkflowComponent.RESULT_MAP_KEY);
        if (result.containsKey("workflowValidation")) {
            return ((ValidationResult)result.get("workflowValidation")).getWarnings();
        }
        return null;
    }

    protected Map _processWorkflowException(Redirector redirector, Map objectModel, String source, Parameters parameters, long actionId, WorkflowException e) throws Exception {
        throw new Exception(String.format("Unable to perform action: '%d' for %s", actionId, this._getExceptionContext(objectModel, source, parameters)), e);
    }

    protected abstract String _getExceptionContext(Map var1, String var2, Parameters var3);
}

