/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.component;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import java.util.Map;
import org.ametys.core.right.Right;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.EnhancedCondition;
import org.ametys.plugins.workflow.component.WorkflowArgument;
import org.ametys.plugins.workflow.support.WorkflowElementDefinitionHelper;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.StaticEnumerator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.commons.lang3.StringUtils;

public class CheckRightsCondition
extends AbstractWorkflowComponent
implements EnhancedCondition,
Initializable,
Disposable {
    public static final String FORCE = CheckRightsCondition.class.getName() + "$force";
    protected static final String __DEFAULT_CONTEXT = "/cms";
    protected static final String __RIGHT_KEY = "right";
    protected static final String __CONTEXT_KEY = "context";
    protected RightManager _rightManager;
    protected RightsExtensionPoint _rightsExtensionPoint;
    protected I18nUtils _i18nUtils;

    public void initialize() throws Exception {
        this._rightManager = (RightManager)this._manager.lookup(RightManager.ROLE);
        this._rightsExtensionPoint = (RightsExtensionPoint)this._manager.lookup(RightsExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)this._manager.lookup(I18nUtils.ROLE);
    }

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        String rightNeeded = (String)args.get(__RIGHT_KEY);
        if (rightNeeded == null) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn(String.format("Missing 'right' argument for workflow action id: %d, failing condition", transientVars.get("actionId")));
            }
            return false;
        }
        Boolean force = (Boolean)transientVars.get(FORCE);
        if (force != null && force.booleanValue()) {
            return true;
        }
        UserIdentity user = this.getUser(transientVars);
        boolean passesCondition = this._checkRights(transientVars, args, user, rightNeeded);
        if (!passesCondition) {
            List<AbstractWorkflowComponent.ConditionFailure> conditionFailures = this.getConditionFailures(transientVars);
            if (conditionFailures != null) {
                conditionFailures.add(new AbstractWorkflowComponent.ConditionFailure(String.format("Check right condition failed for workflow action id %d, user '%s' and right '%s'", transientVars.get("actionId"), user, rightNeeded), CheckRightsCondition.class.getName()));
            }
            this.addWorkflowError(transientVars, new I18nizableText("plugin.workflow", "WORKFLOW_CHECK_RIGHTS_CONDITION_FAILED"));
        }
        return passesCondition;
    }

    protected boolean _checkRights(Map transientVars, Map args, UserIdentity user, String rightNeeded) throws WorkflowException {
        Object context = this._computeContext(transientVars, args, user, rightNeeded);
        if (context == null) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn(String.format("Missing context for checking rights for workflow action id: %d, failing condition", transientVars.get("actionId")));
            }
            return false;
        }
        if (rightNeeded.contains("|")) {
            return this.checkMultipleOrRights(user, StringUtils.split((String)rightNeeded, (char)'|'), context);
        }
        if (rightNeeded.contains("&")) {
            return this.checkMultipleAndRights(user, StringUtils.split((String)rightNeeded, (char)'&'), context);
        }
        return this.hasRight(user, rightNeeded, context);
    }

    protected boolean checkMultipleAndRights(UserIdentity user, String[] rights, Object context) {
        for (String right : rights) {
            if (this.hasRight(user, right, context)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkMultipleOrRights(UserIdentity user, String[] rights, Object context) {
        for (String right : rights) {
            if (!this.hasRight(user, right, context)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasRight(UserIdentity user, String right, Object context) {
        return this._rightManager.hasRight(user, right, context) == RightManager.RightResult.RIGHT_ALLOW;
    }

    protected Object _computeContext(Map transientVars, Map args, UserIdentity user, String right) throws WorkflowException {
        String context = (String)args.get(__CONTEXT_KEY);
        if (context == null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(String.format("Missing 'context' argument, using default context: %s", __DEFAULT_CONTEXT));
            }
            return __DEFAULT_CONTEXT;
        }
        return context;
    }

    public void dispose() {
        this._manager.release((Object)this._rightManager);
        this._rightManager = null;
        this._manager = null;
    }

    @Override
    public List<WorkflowArgument> getArguments() {
        WorkflowArgument rights = WorkflowElementDefinitionHelper.getElementDefinition(__RIGHT_KEY, new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_CHECK_RIGHTS_ARGUMENT_RIGHT_KEY_LABEL"), new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_CHECK_RIGHTS_ARGUMENT_RIGHT_KEY_DESCRIPTION"), true, false);
        rights.setEnumerator((Enumerator)this._getRightsEnumerator());
        return List.of(rights, WorkflowElementDefinitionHelper.getElementDefinition(__CONTEXT_KEY, new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_CHECK_RIGHTS_ARGUMENT_CONTEXT_KEY_LABEL"), new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_CHECK_RIGHTS_ARGUMENT_CONTEXT_KEY_DESCRIPTION"), false, false));
    }

    protected StaticEnumerator _getRightsEnumerator() {
        StaticEnumerator rightsStaticEnumerator = new StaticEnumerator();
        for (String rightId : this._rightsExtensionPoint.getExtensionsIds()) {
            Right right = this._rightsExtensionPoint.getExtension(rightId);
            Map<String, I18nizableText> params = Map.of("category", right.getCategory(), "label", right.getLabel());
            rightsStaticEnumerator.add(new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_CHECK_RIGHTS_ARGUMENT_RIGHT_KEY_PARAMS_LABEL", params), (Object)right.getId());
        }
        return rightsStaticEnumerator;
    }

    @Override
    public I18nizableText getLabel() {
        return new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_EDITOR_CHECK_RIGHTS_CONDITION_LABEL");
    }

    protected I18nizableText _getMultipleConditionsDescriptionKey(List<String> parameters) {
        return new I18nizableText("plugin.workflow", "UITOOL_WORKFLOW_EDITOR_CHECK_RIGHTS_MULTIPLES_CONDITION_DESCRIPTION", parameters);
    }

    protected I18nizableText _getSingleConditionDescriptionKey(List<String> parameters) {
        return new I18nizableText("plugin.workflow", "UITOOL_WORKFLOW_EDITOR_CHECK_RIGHTS_CONDITION_DESCRIPTION", parameters);
    }

    @Override
    public I18nizableText getFullLabel(Map<String, String> argumentsValues) {
        String rightNeeded = argumentsValues.get(__RIGHT_KEY);
        Object translatedRight = "";
        if (rightNeeded.contains("|")) {
            String[] rightsOr = StringUtils.split((String)rightNeeded, (char)'|');
            translatedRight = "<strong>" + this._i18nUtils.translate((I18nizable)this._rightsExtensionPoint.getExtension(rightsOr[0]).getLabel()) + "</strong>";
            for (String rightId : rightsOr) {
                Right right = this._rightsExtensionPoint.getExtension(rightId);
                translatedRight = (String)translatedRight + this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_CONDITION_OR")) + "<strong>" + this._i18nUtils.translate((I18nizable)right.getDescription()) + "</strong>";
            }
            return this._getMultipleConditionsDescriptionKey(List.of(translatedRight));
        }
        if (rightNeeded.contains("&")) {
            String[] rightsAnd = StringUtils.split((String)rightNeeded, (char)'&');
            translatedRight = "<strong>" + this._i18nUtils.translate((I18nizable)this._rightsExtensionPoint.getExtension(rightsAnd[0]).getLabel()) + "</strong>";
            for (String rightId : rightsAnd) {
                Right right = this._rightsExtensionPoint.getExtension(rightId);
                translatedRight = (String)translatedRight + this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_CONDITION_AND")) + "<strong>" + this._i18nUtils.translate((I18nizable)right.getDescription()) + "</strong>";
            }
            return this._getMultipleConditionsDescriptionKey(List.of(translatedRight));
        }
        Right right = this._rightsExtensionPoint.getExtension(rightNeeded);
        translatedRight = "<strong>" + this._i18nUtils.translate((I18nizable)right.getLabel()) + "</strong>";
        return this._getSingleConditionDescriptionKey(List.of(translatedRight));
    }
}

