/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.dao;

import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.workflow.component.WorkflowLanguageManager;
import org.ametys.plugins.workflow.dao.WorkflowConditionDAO;
import org.ametys.plugins.workflow.dao.WorkflowResultDAO;
import org.ametys.plugins.workflow.dao.WorkflowTransitionDAO;
import org.ametys.plugins.workflow.support.I18nHelper;
import org.ametys.plugins.workflow.support.WorflowRightHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowSessionHelper;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class WorkflowStepDAO
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = WorkflowStepDAO.class.getName();
    public static final String INITIAL_STEP_ID = "step0";
    public static final I18nizableText DEFAULT_STEP_NAME = new I18nizableText("plugin.workflow", "PLUGIN_WORKFLOW_DEFAULT_STEP_LABEL");
    private static final String __DEFAULT_SVG_STEP_ICON_PATH = "plugin:cms://resources/img/history/workflow/step_0_16.png";
    private static final String __DEFAULT_STEP_ICON_PATH = "/plugins/cms/resources/img/history/workflow/step_0_16.png";
    protected WorkflowHelper _workflowHelper;
    protected I18nHelper _i18nHelper;
    protected WorkflowSessionHelper _workflowSessionHelper;
    protected WorflowRightHelper _workflowRightHelper;
    protected WorkflowConditionDAO _workflowConditionDAO;
    protected WorkflowResultDAO _workflowResultDAO;
    protected WorkflowTransitionDAO _workflowTransitionDAO;
    protected WorkflowLanguageManager _workflowLanguageManager;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        this._workflowHelper = (WorkflowHelper)((Object)smanager.lookup(WorkflowHelper.ROLE));
        this._workflowSessionHelper = (WorkflowSessionHelper)((Object)smanager.lookup(WorkflowSessionHelper.ROLE));
        this._workflowRightHelper = (WorflowRightHelper)smanager.lookup(WorflowRightHelper.ROLE);
        this._workflowConditionDAO = (WorkflowConditionDAO)((Object)smanager.lookup(WorkflowConditionDAO.ROLE));
        this._workflowTransitionDAO = (WorkflowTransitionDAO)smanager.lookup(WorkflowTransitionDAO.ROLE);
        this._workflowLanguageManager = (WorkflowLanguageManager)smanager.lookup(WorkflowLanguageManager.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._i18nHelper = (I18nHelper)((Object)smanager.lookup(I18nHelper.ROLE));
        this._workflowResultDAO = (WorkflowResultDAO)((Object)smanager.lookup(WorkflowResultDAO.ROLE));
    }

    @Callable(rights={""})
    public boolean hasSteps(String workflowName) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkReadRight(workflowDescriptor);
        return !workflowDescriptor.getSteps().isEmpty();
    }

    @Callable(rights={""})
    public Map<String, Object> getStepInfos(String workflowName, Integer stepId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkReadRight(workflowDescriptor);
        HashMap<String, Object> stepInfos = new HashMap<String, Object>();
        List<Integer> stepIds = this._getUsedStepIds(workflowDescriptor);
        Map<String, String> translations = new HashMap<String, String>();
        if (stepId == null) {
            int id = this._getUniqueStepId(workflowDescriptor);
            stepInfos.put("id", id);
            translations.put(this._workflowLanguageManager.getCurrentLanguage(), this._i18nUtils.translate((I18nizable)DEFAULT_STEP_NAME));
        } else {
            stepIds.remove(stepId);
            stepInfos.put("id", stepId);
            I18nizableText labelKey = this.getStepLabel(workflowDescriptor, stepId);
            translations = this._workflowSessionHelper.getTranslation(workflowName, labelKey);
            if (translations == null) {
                translations = Map.of(this._workflowLanguageManager.getCurrentLanguage(), this.getStepLabelAsString(workflowDescriptor, stepId, false));
            }
        }
        stepInfos.put("labels", translations);
        stepInfos.put("ids", stepIds);
        return stepInfos;
    }

    private List<Integer> _getUsedStepIds(WorkflowDescriptor workflowDescriptor) {
        List<Integer> usedIds = workflowDescriptor.getSteps().stream().map(s -> ((StepDescriptor)s).getId()).collect(Collectors.toList());
        usedIds.add(0);
        return usedIds;
    }

    @Callable(rights={""})
    public Map<String, Object> createStep(String workflowName, Integer stepId, Map<String, String> labels) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        HashMap<String, Object> results = new HashMap<String, Object>();
        List<Integer> stepIds = this._getUsedStepIds(workflowDescriptor);
        if (stepIds.contains(stepId) || stepId == 0) {
            results.put("message", "duplicate-id");
            return results;
        }
        DescriptorFactory factory = new DescriptorFactory();
        StepDescriptor stepDescriptor = factory.createStepDescriptor();
        stepDescriptor.setId(stepId.intValue());
        I18nizableText stepLabelKey = this._i18nHelper.generateI18nKey(workflowName, "STEP", stepId);
        stepDescriptor.setName(stepLabelKey.toString());
        workflowDescriptor.addStep(stepDescriptor);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        this._workflowSessionHelper.updateTranslations(workflowName, stepLabelKey, labels);
        results.put("stepId", stepId);
        results.put("stepLabels", labels);
        results.put("workflowId", workflowName);
        return results;
    }

    private int _getUniqueStepId(WorkflowDescriptor workflowDescriptor) {
        List<Integer> stepIds = this._getUsedStepIds(workflowDescriptor);
        int id = 1;
        while (stepIds.contains(id)) {
            ++id;
        }
        return id;
    }

    @Callable(rights={""})
    public Map<String, Object> editStepLabel(String workflowName, Integer stepId, String newMainLabel) {
        return this.editStep(workflowName, stepId, stepId, Map.of(this._workflowLanguageManager.getCurrentLanguage(), newMainLabel));
    }

    @Callable(rights={""})
    public Map<String, Object> editStep(String workflowName, Integer oldId, Integer id, Map<String, String> labels) {
        I18nizableText labelKey;
        String defaultCatalog;
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        HashMap<String, Object> results = new HashMap<String, Object>();
        StepDescriptor stepDescriptor = workflowDescriptor.getStep(oldId.intValue());
        if (id != oldId) {
            if (!this.getIncomingActions(oldId, workflowDescriptor).isEmpty()) {
                results.put("message", "incoming-actions");
                return results;
            }
            List<Integer> stepIds = this._getUsedStepIds(workflowDescriptor);
            if (stepIds.contains(id)) {
                results.put("message", "duplicate-id");
                return results;
            }
            stepDescriptor.setId(id.intValue());
        }
        if (!(defaultCatalog = this._workflowHelper.getWorkflowCatalog(workflowName)).equals((labelKey = this.getStepLabel(workflowDescriptor, id)).getCatalogue())) {
            labelKey = new I18nizableText(defaultCatalog, labelKey.getKey());
            String newName = labelKey.toString();
            stepDescriptor.setName(newName);
        }
        this._workflowSessionHelper.updateTranslations(workflowName, labelKey, labels);
        results.put("stepId", id);
        results.put("oldStepId", oldId);
        results.put("stepLabels", labels);
        results.put("workflowId", workflowName);
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> deleteStep(String workflowName, Integer stepId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        HashMap<String, Object> results = new HashMap<String, Object>();
        StepDescriptor stepDescriptor = workflowDescriptor.getStep(stepId.intValue());
        if (this.getIncomingActions(stepId, workflowDescriptor).isEmpty()) {
            I18nizableText stepLabel = this.getStepLabel(workflowDescriptor, stepId);
            workflowDescriptor.getSteps().remove(stepDescriptor);
            this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
            this._workflowSessionHelper.removeTranslation(workflowName, this.getStepLabel(stepDescriptor));
            results.put("stepId", stepId);
            results.put("stepLabels", stepLabel);
            results.put("workflowId", workflowName);
        } else {
            results.put("message", "incoming-actions");
        }
        return results;
    }

    public I18nizableText getStepLabel(StepDescriptor stepDescriptor) {
        return new I18nizableText("application", stepDescriptor.getName());
    }

    @Callable(rights={""})
    public Map<String, Object> getStepNodes(String currentNode, String workflowName) {
        ArrayList<Map<String, Object>> nodes;
        block7: {
            WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
            this._workflowRightHelper.checkReadRight(workflowDescriptor);
            nodes = new ArrayList<Map<String, Object>>();
            boolean canWrite = this._workflowRightHelper.canWrite(workflowDescriptor);
            if (workflowName == null) break block7;
            List initialActions = workflowDescriptor.getInitialActions();
            if (currentNode.equals("root")) {
                Map<String, Object> infosInitialStep = this._step2JSON(workflowDescriptor, 0, initialActions.size() > 0, false, false);
                nodes.add(infosInitialStep);
                List steps = workflowDescriptor.getSteps();
                for (StepDescriptor step : steps) {
                    Map<String, Object> infos = this._step2JSON(workflowDescriptor, step.getId(), step.getActions().size() > 0, false, canWrite);
                    nodes.add(infos);
                }
            } else if (currentNode.equals(INITIAL_STEP_ID)) {
                for (ActionDescriptor initialAction : initialActions) {
                    nodes.add(this._action2JSON(currentNode, initialAction, workflowDescriptor, canWrite));
                }
            } else {
                StepDescriptor step = workflowDescriptor.getStep(Integer.valueOf(currentNode.substring("step".length())).intValue());
                for (ActionDescriptor transition : step.getActions()) {
                    nodes.add(this._action2JSON(currentNode, transition, workflowDescriptor, canWrite));
                }
            }
        }
        return Map.of("steps", nodes);
    }

    protected Map<String, Object> _action2JSON(String stepId, ActionDescriptor action, WorkflowDescriptor workflowDescriptor, boolean canWrite) {
        Set<StepWithIcon> finalSteps = this._getActionFinalSteps(action, workflowDescriptor);
        Map<Integer, Object> finalStepNames = finalSteps.stream().collect(Collectors.toMap(s -> s.id(), s -> s.label()));
        Map<Integer, Object> finalStepIcons = finalSteps.stream().collect(Collectors.toMap(s -> s.id(), s -> s.iconPath()));
        String iconPath = this._workflowTransitionDAO.getActionIconPath(workflowDescriptor.getName(), action);
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", stepId + "-action" + action.getId());
        infos.put("elementId", action.getId());
        infos.put("smallIcon", iconPath);
        infos.put("label", this._workflowTransitionDAO.getActionLabel(workflowDescriptor.getName(), action));
        infos.put("elementType", "action");
        infos.put("hasChildren", false);
        infos.put("targetedStepNames", finalStepNames);
        infos.put("targetedStepIcons", finalStepIcons);
        infos.put("canWrite", canWrite);
        return infos;
    }

    protected Set<StepWithIcon> _getActionFinalSteps(ActionDescriptor action, WorkflowDescriptor workflowDescriptor) {
        HashSet<StepWithIcon> steps = new HashSet<StepWithIcon>();
        for (StepDescriptor step : this.getOutgoingSteps(action, workflowDescriptor)) {
            int stepId = step.getId();
            steps.add(new StepWithIcon(stepId, this.getStepLabelAsString(workflowDescriptor, stepId, false), this.getStepIconPath(workflowDescriptor, stepId)));
        }
        return steps;
    }

    public Set<StepDescriptor> getOutgoingSteps(ActionDescriptor action, WorkflowDescriptor workflowDescriptor) {
        HashSet<StepDescriptor> outgoingSteps = new HashSet<StepDescriptor>();
        ResultDescriptor unconditionalResult = action.getUnconditionalResult();
        boolean hasSameStepTarget = false;
        if (unconditionalResult.getStep() != -1) {
            StepDescriptor unconditionalStep = workflowDescriptor.getStep(unconditionalResult.getStep());
            outgoingSteps.add(unconditionalStep);
        } else {
            hasSameStepTarget = true;
        }
        List conditionalResults = action.getConditionalResults();
        for (ConditionalResultDescriptor result : conditionalResults) {
            StepDescriptor conditionalStep = workflowDescriptor.getStep(result.getStep());
            if (conditionalStep != null) {
                outgoingSteps.add(conditionalStep);
                continue;
            }
            hasSameStepTarget = true;
        }
        if (hasSameStepTarget) {
            outgoingSteps.addAll(this.getIncomingSteps(action.getId(), workflowDescriptor));
        }
        return outgoingSteps;
    }

    public Set<StepDescriptor> getIncomingSteps(int actionId, WorkflowDescriptor workflowDescriptor) {
        HashSet<StepDescriptor> incomingSteps = new HashSet<StepDescriptor>();
        List steps = workflowDescriptor.getSteps();
        for (StepDescriptor step : steps) {
            if (step.getAction(actionId) == null) continue;
            incomingSteps.add(step);
        }
        return incomingSteps;
    }

    @Callable(rights={""})
    public Map<String, Object> getFinalSteps(String currentNode, String workflowName, Integer actionId) {
        ArrayList<Map<String, Object>> nodes;
        block2: {
            List conditionalResults;
            ActionDescriptor action;
            block3: {
                int stepId;
                WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
                nodes = new ArrayList<Map<String, Object>>();
                if (!this._workflowRightHelper.canRead(workflowDescriptor)) break block2;
                action = workflowDescriptor.getAction(actionId.intValue());
                boolean canWrite = this._workflowRightHelper.canWrite(workflowDescriptor);
                conditionalResults = action.getConditionalResults();
                if (!currentNode.equals("root")) break block3;
                ResultDescriptor unconditionalResult = action.getUnconditionalResult();
                Map<String, Object> step2json = this._step2JSON(workflowDescriptor, stepId, false, (stepId = unconditionalResult.getStep()) != -1, canWrite);
                step2json.put("isConditional", false);
                nodes.add(step2json);
                for (ConditionalResultDescriptor result : conditionalResults) {
                    stepId = result.getStep();
                    Map<String, Object> conditionalStep2Json = this._step2JSON(workflowDescriptor, stepId, !result.getConditions().isEmpty(), stepId != -1, canWrite);
                    conditionalStep2Json.put("isConditional", true);
                    nodes.add(conditionalStep2Json);
                }
                break block2;
            }
            List<AbstractDescriptor> conditions = this._workflowResultDAO.getChildrenResultConditions(currentNode, action, conditionalResults);
            if (conditions.isEmpty()) break block2;
            String[] path = this._workflowResultDAO.getPath(currentNode);
            int stepId = Integer.valueOf(path[0].substring(4));
            ConditionsDescriptor rootOperator = this._workflowResultDAO.getRootResultConditions(conditionalResults, stepId).get(0);
            boolean rootIsAND = !rootOperator.getType().equals("OR");
            for (int i = 0; i < conditions.size(); ++i) {
                nodes.add(this._workflowConditionDAO.conditionToJSON(conditions.get(i), currentNode, i, rootIsAND));
            }
        }
        return Map.of("results", nodes);
    }

    protected Map<String, Object> _step2JSON(WorkflowDescriptor workflowDescriptor, int stepId, boolean hasChildren, boolean showId, boolean canWrite) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", "step" + stepId);
        infos.put("elementId", stepId);
        infos.put("label", this.getStepLabelAsString(workflowDescriptor, stepId, showId));
        infos.put("elementType", "step");
        infos.put("hasChildren", hasChildren);
        infos.put("canWrite", canWrite);
        try {
            infos.put("smallIcon", this.getStepIconPath(workflowDescriptor, stepId));
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred while getting icon path for step id {}", (Object)stepId, (Object)e);
        }
        return infos;
    }

    @Callable(rights={""})
    public Map<String, Object> getStatesToJson(String workflowName, Integer actionId, Boolean isInitialState) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkReadRight(workflowDescriptor);
        ArrayList states = new ArrayList();
        ArrayList<Integer> conditionalStepIds = new ArrayList<Integer>();
        List steps = workflowDescriptor.getSteps();
        if (actionId != null) {
            ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
            List conditionalResults = action.getConditionalResults();
            for (ConditionalResultDescriptor conditionalResult : conditionalResults) {
                conditionalStepIds.add(conditionalResult.getStep());
            }
        }
        for (StepDescriptor step : steps) {
            int stepId = step.getId();
            if (conditionalStepIds.contains(stepId)) continue;
            HashMap<String, Object> stateInfos = new HashMap<String, Object>();
            stateInfos.put("id", stepId);
            stateInfos.put("label", this.getStepLabelAsString(workflowDescriptor, stepId, true));
            states.add(stateInfos);
        }
        if (!isInitialState.booleanValue() && !conditionalStepIds.contains(-1)) {
            HashMap<String, Integer> stateInfos = new HashMap<String, Integer>();
            stateInfos.put("id", -1);
            stateInfos.put("label", (Integer)new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_RESULTS_SAME_STEP"));
            states.add(stateInfos);
        }
        return Map.of("data", states);
    }

    public String getStepLabelAsString(WorkflowDescriptor workflowDescriptor, int stepId, boolean showId) {
        I18nizableText label = this.getStepLabel(workflowDescriptor, stepId);
        return showId ? this._i18nHelper.translateKey(workflowDescriptor.getName(), label, DEFAULT_STEP_NAME) + " (" + stepId + ")" : this._i18nHelper.translateKey(workflowDescriptor.getName(), label, DEFAULT_STEP_NAME);
    }

    public String getStepIconPath(WorkflowDescriptor workflowDescriptor, int stepId) {
        I18nizableText label = this.getStepLabel(workflowDescriptor, stepId);
        label = this._workflowSessionHelper.getOldLabelKeyIfCloned(workflowDescriptor.getName(), label);
        return this._workflowHelper.getElementIconPath(label, __DEFAULT_STEP_ICON_PATH);
    }

    public String getStepIconPathAsBase64(WorkflowDescriptor workflowDescriptor, int stepId) {
        I18nizableText label = this.getStepLabel(workflowDescriptor, stepId);
        label = this._workflowSessionHelper.getOldLabelKeyIfCloned(workflowDescriptor.getName(), label);
        return this._workflowHelper.getElementIconAsBase64(label, __DEFAULT_SVG_STEP_ICON_PATH);
    }

    public I18nizableText getStepLabel(WorkflowDescriptor workflowDescriptor, int stepId) {
        switch (stepId) {
            case -1: {
                return new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_RESULTS_SAME_STEP");
            }
            case 0: {
                return new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_INITIAL_STEP_NAME");
            }
        }
        StepDescriptor step = workflowDescriptor.getStep(stepId);
        return this.getStepLabel(step);
    }

    public List<ActionDescriptor> getOutgoingActions(int stepId, WorkflowDescriptor workflow) {
        return stepId != 0 ? workflow.getStep(stepId).getActions() : workflow.getInitialActions();
    }

    public Set<ActionDescriptor> getIncomingActions(int stepId, WorkflowDescriptor workflow) {
        HashSet<ActionDescriptor> incomingActions = new HashSet<ActionDescriptor>();
        if (stepId != 0) {
            incomingActions.addAll(this._getIncomingActionsFromList(stepId, workflow.getInitialActions()));
            List steps = workflow.getSteps();
            for (StepDescriptor otherSteps : steps) {
                if (otherSteps.getId() == stepId) continue;
                List actions = otherSteps.getActions();
                incomingActions.addAll(this._getIncomingActionsFromList(stepId, actions));
            }
        }
        return incomingActions;
    }

    protected Set<ActionDescriptor> _getIncomingActionsFromList(int stepId, List<ActionDescriptor> actions) {
        HashSet<ActionDescriptor> incoming = new HashSet<ActionDescriptor>();
        for (ActionDescriptor action : actions) {
            ResultDescriptor unconditionalResult = action.getUnconditionalResult();
            if (unconditionalResult.getStep() == stepId) {
                incoming.add(action);
                continue;
            }
            boolean leadToStep = false;
            List conditionalResults = action.getConditionalResults();
            for (int indexResult = 0; !leadToStep && indexResult < conditionalResults.size(); ++indexResult) {
                if (((ResultDescriptor)conditionalResults.get(indexResult)).getStep() != stepId) continue;
                incoming.add(action);
                leadToStep = true;
            }
        }
        return incoming;
    }

    public String getFirstParentStepId(int stepId, List<StepDescriptor> steps, Integer actionId) {
        String firstParentStepId = "";
        int i = 0;
        do {
            StepDescriptor otherStep;
            if ((otherStep = steps.get(i)).getId() == stepId || otherStep.getAction(actionId.intValue()) == null) continue;
            firstParentStepId = String.valueOf(otherStep.getId());
        } while (firstParentStepId.isEmpty() && ++i < steps.size());
        return firstParentStepId.isBlank() ? "0" : firstParentStepId;
    }

    private record StepWithIcon(Integer id, String label, String iconPath) {
    }
}

