/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.store;

import com.opensymphony.workflow.spi.Step;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workflow.store.AbstractJackrabbitWorkflowStore;

public class AmetysStep
implements Step {
    protected static final String __CUSTOM_PROP_PREFIX = "ametys:";
    private Node _node;
    private AbstractJackrabbitWorkflowStore _store;

    public AmetysStep(Node node, AbstractJackrabbitWorkflowStore store) {
        this._node = node;
        this._store = store;
    }

    Node getNode() {
        return this._node;
    }

    public long getId() {
        try {
            return this._node.getProperty("oswf:id").getLong();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the ID property.", (Throwable)e);
        }
    }

    public long getEntryId() {
        try {
            return this._node.getParent().getProperty("oswf:id").getLong();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the entry ID property.", (Throwable)e);
        }
    }

    public int getStepId() {
        try {
            return (int)this._node.getProperty("oswf:stepId").getLong();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the step ID property.", (Throwable)e);
        }
    }

    public void setStepId(int stepId) {
        try {
            this._node.setProperty("oswf:stepId", (long)stepId);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the step ID property.", (Throwable)e);
        }
    }

    public int getActionId() {
        try {
            if (this._node.hasProperty("oswf:actionId")) {
                return (int)this._node.getProperty("oswf:actionId").getLong();
            }
            return 0;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the action ID property.", (Throwable)e);
        }
    }

    public void setActionId(int actionId) {
        try {
            this._node.setProperty("oswf:actionId", (long)actionId);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the action ID property.", (Throwable)e);
        }
    }

    public String getCaller() {
        try {
            String caller = null;
            if (this._node.hasProperty("oswf:caller")) {
                caller = this._node.getProperty("oswf:caller").getString();
            }
            return caller;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the caller property.", (Throwable)e);
        }
    }

    public void setCaller(String caller) {
        try {
            this._node.setProperty("oswf:caller", caller);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the caller property.", (Throwable)e);
        }
    }

    public Date getStartDate() {
        try {
            Date value = null;
            if (this._node.hasProperty("oswf:startDate")) {
                value = this._node.getProperty("oswf:startDate").getDate().getTime();
            }
            return value;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the start date property.", (Throwable)e);
        }
    }

    public void setStartDate(Date startDate) {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(startDate);
            this._node.setProperty("oswf:startDate", (Calendar)cal);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the start date property.", (Throwable)e);
        }
    }

    public Date getDueDate() {
        try {
            Date value = null;
            if (this._node.hasProperty("oswf:dueDate")) {
                value = this._node.getProperty("oswf:dueDate").getDate().getTime();
            }
            return value;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the due date property.", (Throwable)e);
        }
    }

    public void setDueDate(Date dueDate) {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(dueDate);
            this._node.setProperty("oswf:dueDate", (Calendar)cal);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the due date property.", (Throwable)e);
        }
    }

    public Date getFinishDate() {
        try {
            Date value = null;
            if (this._node.hasProperty("oswf:finishDate")) {
                value = this._node.getProperty("oswf:finishDate").getDate().getTime();
            }
            return value;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the finish date property.", (Throwable)e);
        }
    }

    public void setFinishDate(Date finishDate) {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(finishDate);
            this._node.setProperty("oswf:finishDate", (Calendar)cal);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the finish date property.", (Throwable)e);
        }
    }

    public String getOwner() {
        try {
            String owner = null;
            if (this._node.hasProperty("oswf:owner")) {
                owner = this._node.getProperty("oswf:owner").getString();
            }
            return owner;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the owner property.", (Throwable)e);
        }
    }

    public void setOwner(String owner) {
        try {
            this._node.setProperty("oswf:owner", owner);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the owner property.", (Throwable)e);
        }
    }

    public long[] getPreviousStepIds() {
        try {
            ArrayList<Long> previousStepsIds = new ArrayList<Long>();
            if (this._node.hasProperty("oswf:previousSteps")) {
                Value[] previousSteps;
                for (Value previousStep : previousSteps = this._node.getProperty("oswf:previousSteps").getValues()) {
                    Node historyStep = this._node.getSession().getNodeByIdentifier(previousStep.getString());
                    long previousStepId = historyStep.getProperty("oswf:id").getLong();
                    previousStepsIds.add(previousStepId);
                }
            }
            long[] previousIds = new long[previousStepsIds.size()];
            for (int i = 0; i < previousIds.length; ++i) {
                previousIds[i] = (Long)previousStepsIds.get(i);
            }
            return previousIds;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the previous IDs property.", (Throwable)e);
        }
    }

    public void setPreviousStepIds(long[] previousStepIds) {
        try {
            Session session = this._node.getSession();
            ValueFactory valueFactory = session.getValueFactory();
            Value[] previousStepsRefs = new Value[]{};
            if (previousStepIds != null) {
                previousStepsRefs = new Value[previousStepIds.length];
                for (int i = 0; i < previousStepIds.length; ++i) {
                    long previousStepId = previousStepIds[i];
                    Node previousStep = this._store.getHistoryStepNode(session, this.getEntryId(), previousStepId);
                    previousStepsRefs[i] = valueFactory.createValue(previousStep);
                }
            }
            this._node.setProperty("oswf:previousSteps", previousStepsRefs);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the previous IDs property.", (Throwable)e);
        }
    }

    public String getStatus() {
        try {
            String status = null;
            if (this._node.hasProperty("oswf:status")) {
                status = this._node.getProperty("oswf:status").getString();
            }
            return status;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the status property.", (Throwable)e);
        }
    }

    public void setStatus(String status) {
        try {
            this._node.setProperty("oswf:status", status);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the status property.", (Throwable)e);
        }
    }

    public Object getProperty(String name) {
        try {
            Object value = null;
            String qName = __CUSTOM_PROP_PREFIX + name;
            if (this._node.hasProperty(qName)) {
                Property property = this._node.getProperty(qName);
                value = property.getDefinition().isMultiple() ? this.getMultiValuedProperty(property) : this.getSingleValuedProperty(property);
            }
            return value;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the custom property: " + name, (Throwable)e);
        }
    }

    public void setProperty(String name, Object value) {
        try {
            ValueFactory valueFactory = this._node.getSession().getValueFactory();
            String qName = __CUSTOM_PROP_PREFIX + name;
            if (value instanceof Boolean) {
                this._node.setProperty(qName, ((Boolean)value).booleanValue());
            } else if (value instanceof boolean[]) {
                boolean[] v = (boolean[])value;
                Value[] values = new Value[v.length];
                for (int i = 0; i < v.length; ++i) {
                    values[i] = valueFactory.createValue(v[i]);
                }
                this._node.setProperty(qName, values);
            } else if (value instanceof Date) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTime((Date)value);
                this._node.setProperty(qName, (Calendar)gc);
            } else if (value instanceof Date[]) {
                Date[] v = (Date[])value;
                Value[] values = new Value[v.length];
                for (int i = 0; i < v.length; ++i) {
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.setTime(v[i]);
                    values[i] = valueFactory.createValue((Calendar)gc);
                }
                this._node.setProperty(qName, values);
            } else if (value instanceof Long) {
                this._node.setProperty(qName, ((Long)value).longValue());
            } else if (value instanceof long[]) {
                long[] v = (long[])value;
                Value[] values = new Value[v.length];
                for (int i = 0; i < v.length; ++i) {
                    values[i] = valueFactory.createValue(v[i]);
                }
                this._node.setProperty(qName, values);
            } else if (value instanceof String[]) {
                String[] v = (String[])value;
                Value[] values = new Value[v.length];
                for (int i = 0; i < v.length; ++i) {
                    values[i] = valueFactory.createValue(v[i]);
                }
                this._node.setProperty(qName, values);
            } else {
                this._node.setProperty(qName, value.toString());
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the custom property: " + name, (Throwable)e);
        }
    }

    public Set<String> getPropertyNames() {
        try {
            LinkedHashSet<String> propertyNames = new LinkedHashSet<String>();
            PropertyIterator properties = this._node.getProperties("ametys:*");
            while (properties.hasNext()) {
                String qName = properties.nextProperty().getName();
                String name = qName.substring(__CUSTOM_PROP_PREFIX.length());
                propertyNames.add(name);
            }
            return propertyNames;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error retrieving the custom property list.", (Throwable)e);
        }
    }

    public void save() {
        try {
            this._node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error saving the .", (Throwable)e);
        }
    }

    protected Object getSingleValuedProperty(Property property) throws RepositoryException {
        return switch (property.getType()) {
            case 6 -> property.getBoolean();
            case 5 -> property.getDate().getTime();
            case 3 -> property.getLong();
            default -> property.getString();
        };
    }

    protected Object getMultiValuedProperty(Property property) throws RepositoryException {
        Value[] values = property.getValues();
        return switch (property.getType()) {
            case 6 -> {
                boolean[] booleanResults = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    booleanResults[i] = values[i].getBoolean();
                }
                yield booleanResults;
            }
            case 5 -> {
                Date[] dateResults = new Date[values.length];
                for (int i = 0; i < values.length; ++i) {
                    dateResults[i] = values[i].getDate().getTime();
                }
                yield (Object[])dateResults;
            }
            case 3 -> {
                long[] longResults = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    longResults[i] = values[i].getLong();
                }
                yield (Object[])longResults;
            }
            default -> {
                String[] stringResults = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    stringResults[i] = values[i].getString();
                }
                yield (Object[])stringResults;
            }
        };
    }

    public String toString() {
        return "AmetysStep (" + this.getId() + ")";
    }
}

