/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.support;

import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class I18nMessageHandler
extends DefaultHandler {
    private Map<I18nizableText, String> _map;
    private StringBuilder _currentText;
    private String _catalog;
    private String _currentKey;
    private boolean _message;

    public I18nMessageHandler(Map<I18nizableText, String> i18nMessages, String catalog) {
        this._map = i18nMessages;
        this._catalog = catalog;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this._message = false;
        if (qName.equals("message")) {
            this._message = true;
            this._currentText = new StringBuilder();
            this._currentKey = attributes.getValue("key");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._message) {
            this._currentText.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("message")) {
            this._map.put(new I18nizableText(this._catalog, this._currentKey), this._currentText.toString());
            this._message = false;
        }
    }
}

