/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.support;

import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class WorflowRightHelper
implements Component,
Serviceable {
    public static final String ROLE = WorflowRightHelper.class.getName();
    private static final String __WORKFLOW_RIGHT_READ_SYSTEM = "Workflow_Right_Read";
    private static final String __WORKFLOW_RIGHT_READ_USER = "Workflow_Right_Read_User";
    private static final String __WORKFLOW_RIGHT_EDIT_SYSTEM = "Workflow_Right_Edit";
    private static final String __WORKFLOW_RIGHT_EDIT_USER = "Workflow_Right_Edit_User";
    protected RightManager _rightManager;
    protected Context _context;
    protected CurrentUserProvider _userProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._userProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public void checkReadRight(WorkflowDescriptor workflow) {
        UserIdentity currentUser = this._userProvider.getUser();
        if (!this.canRead(workflow)) {
            throw new IllegalAccessError("User '" + String.valueOf(currentUser) + "' tried to handle workflows without convenient right ['Workflow_Right_Read_User' or 'Workflow_Right_Read' or 'Workflow_Right_Edit_User' or 'Workflow_Right_Edit']");
        }
    }

    public void checkEditRight() {
        UserIdentity currentUser = this._userProvider.getUser();
        if (!this.hasEditUserRight()) {
            throw new IllegalAccessError("User '" + String.valueOf(currentUser) + "' tried to handle workflows without convenient right ['Workflow_Right_Edit']");
        }
    }

    public void checkEditRight(WorkflowDescriptor workflow) {
        UserIdentity currentUser = this._userProvider.getUser();
        if (!this.canWrite(workflow)) {
            throw new IllegalAccessError("User '" + String.valueOf(currentUser) + "' tried to handle workflow " + workflow.getName() + " without convenient right ['Workflow_Right_Edit']");
        }
    }

    public boolean canWrite(WorkflowDescriptor workflow) {
        Map metaAttributes = workflow.getMetaAttributes();
        return metaAttributes.containsKey("user") ? this.hasEditUserRight() : this.hasEditSystemRight();
    }

    public boolean canRead(WorkflowDescriptor workflow) {
        Map metaAttributes = workflow.getMetaAttributes();
        return metaAttributes.containsKey("user") ? this._hasReadUserRight() : this._hasReadSystemRight();
    }

    public boolean hasEditUserRight() {
        UserIdentity currentUser = this._userProvider.getUser();
        return this._rightManager.hasRight(currentUser, __WORKFLOW_RIGHT_EDIT_USER, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.hasRight(currentUser, __WORKFLOW_RIGHT_EDIT_SYSTEM, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean hasEditSystemRight() {
        UserIdentity currentUser = this._userProvider.getUser();
        return this._rightManager.hasRight(currentUser, __WORKFLOW_RIGHT_EDIT_SYSTEM, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW;
    }

    private boolean _hasReadUserRight() {
        UserIdentity currentUser = this._userProvider.getUser();
        return this._rightManager.hasRight(currentUser, __WORKFLOW_RIGHT_READ_USER, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.hasRight(currentUser, __WORKFLOW_RIGHT_READ_SYSTEM, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW || this.hasEditUserRight();
    }

    private boolean _hasReadSystemRight() {
        UserIdentity currentUser = this._userProvider.getUser();
        return this._rightManager.hasRight(currentUser, __WORKFLOW_RIGHT_READ_SYSTEM, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW || this.hasEditSystemRight();
    }
}

