/*
 * Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
 * This class controls the ribbon button to add workflow AND operator
 * @private
 */
Ext.define('Ametys.plugins.workflow.controllers.AddANDOperatorController', {
    extend: 'Ametys.plugins.workflow.controllers.AddConditionController',

    getErrorDescription: function(matchingTarget)
    {
        var errorDesc = this.callParent([matchingTarget]);
        if (errorDesc != "")
        {
            return errorDesc;
        }
        
        var actionTarget = matchingTarget.getSubtarget(function(target){return target.getId() == Ametys.message.MessageTarget.WORKFLOW_ACTION});
        var operatorTarget = actionTarget.getSubtarget(function(target){return target.getId() == Ametys.message.MessageTarget.WORKFLOW_CONDITIONS_OPERATOR});
        if (operatorTarget)
        {
            return "";
        }
        
        return this.getInitialConfig("selection-description-nomatch");
    }
});
