/*
 * Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
 * This class controls the ribbon button to add workflow condition and OR operator
 * @private
 */
Ext.define('Ametys.plugins.workflow.controllers.AddConditionController', {
    extend: 'Ametys.plugins.workflow.controllers.WorkflowController',

    getErrorDescription: function(matchingTarget)
    {
        var actionTarget = matchingTarget.getSubtarget(function(target){return target.getId() == Ametys.message.MessageTarget.WORKFLOW_ACTION});
        if (!actionTarget)
        {
            return this.getInitialConfig("selection-description-nomatch");
        }
        
        var conditionTarget = actionTarget.getSubtarget(function(target){return target.getId() == Ametys.message.MessageTarget.WORKFLOW_CONDITION});
        if (conditionTarget)
        {
            return this.getInitialConfig("is-condition-description");
        }
        
        var resultTarget = actionTarget.getSubtarget(function(target){return target.getId() == Ametys.message.MessageTarget.WORKFLOW_RESULT});
        if(resultTarget && !resultTarget.getParameters().isConditional)
        {
            return this.getInitialConfig("unconditional-result-description");
        }
        return "";
    }
});
