/*
 * Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
 * This class controls the ribbon buttons in the conditional result group
 * @private
 */
Ext.define('Ametys.plugins.workflow.controllers.AddResultController', {
    extend: 'Ametys.plugins.workflow.controllers.WorkflowController',
    
    _getStatus: function (targets)
    {
        var description = this.getInitialConfig("description") || this.getInitialConfig("default-description") || '';
        if (targets.length > 0)
        {       
            // Multiselection is currently not supported
            var matchingTarget = targets[0];
            
            this._errorDescription = "";
            
            if (!matchingTarget.getParameters().canWrite)
            {
                this._errorDescription = "{{i18n PLUGINS_WORKFLOW_CANT_WRITE_DESCRIPTION}}";
                this._handleErrors(description)
            }
            else
            {
                var actionTarget = matchingTarget.getSubtarget(function(target){return target.getId() == Ametys.message.MessageTarget.WORKFLOW_ACTION});
                if (actionTarget)
                {
                    var targetParameters = actionTarget.getParameters();
                    var workflowName = targetParameters.workflowId;
                    var actionId = targetParameters.id;
                    Ametys.plugins.workflow.dao.WorkflowResultDAO.getConditionalResultsToJson([workflowName, parseInt(actionId), null], Ext.bind(this._getConditionalResultsToJsonCB, this, [description], 1));
                }
                else
                {
                    this._errorDescription = this.getConfig("selection-description-nomatch");
                    this._handleErrors(description);
                }
            }
        }
        else
        {
            this.stopRefreshing();
            this.setDescription (description);
        }
    },
    
    /**
     * @private
     * Callback of getConditionalResultsToJson, set error message if there isn't any availables results
     * @param {String} description the button's description
     */
    _getConditionalResultsToJsonCB: function(response, description)
    {
        var results = response.data;
        this._errorDescription = results.length
            ? ""
            : this.getInitialConfig("no-conditional-result-description");
        this._handleErrors(description)
    },
    
    /**
     * @private
     * Handle the error message if there is one, else enable button
     * @param {String} description the button's description
     */
    _handleErrors(description)
    {
        if (this._errorDescription == '')
        {
            this.enable();
        }
        else
        {
            if (description != '')
            {
                description += "<br/><br/>";
            }
            description += this._errorDescription;
            this.disable();
        }
        this.stopRefreshing();
        this.setDescription (description);
    }
});
