--
--  Copyright 2009 Anyware Services
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
--
drop table if exists OS_PROPERTYENTRY;
drop table if exists OS_CURRENTSTEP_PREV;
drop table if exists OS_HISTORYSTEP_PREV;
drop table if exists OS_CURRENTSTEP;
drop table if exists OS_HISTORYSTEP;
drop table if exists OS_WFENTRY;
drop table if exists OS_STEPIDS;
drop table if exists OS_ENTRYIDS;

create table OS_PROPERTYENTRY
(
        GLOBAL_KEY varchar(250) NOT NULL,
        ITEM_KEY varchar(250) NOT NULL,
        ITEM_TYPE tinyint,
        STRING_VALUE varchar(255),
        DATE_VALUE datetime,
        DATA_VALUE blob,
        FLOAT_VALUE float,
        NUMBER_VALUE numeric,
        primary key (GLOBAL_KEY, ITEM_KEY)
) ENGINE=InnoDB;

create table OS_WFENTRY
(
    ID bigint NOT NULL,
    NAME varchar(255),
    STATE integer,
    primary key (ID)
) ENGINE=InnoDB;

drop table if exists OS_CURRENTSTEP;
create table OS_CURRENTSTEP
(
    ID bigint NOT NULL,
    ENTRY_ID bigint,
    STEP_ID integer,
    ACTION_ID integer,
    OWNER varchar(200),
    START_DATE datetime,
    FINISH_DATE datetime,
    DUE_DATE datetime,
    STATUS varchar(40),
    CALLER varchar(200),

    primary key (ID),
    index (ENTRY_ID),
    foreign key (ENTRY_ID) references OS_WFENTRY(ID) ON DELETE CASCADE
) ENGINE=InnoDB;

drop table if exists OS_HISTORYSTEP;
create table OS_HISTORYSTEP
(
    ID bigint NOT NULL,
    ENTRY_ID bigint,
    STEP_ID integer,
    ACTION_ID integer,
    OWNER varchar(200),
    START_DATE datetime,
    FINISH_DATE datetime,
    DUE_DATE datetime,
    STATUS varchar(40),
    CALLER varchar(200),

    primary key (ID),
    index (ENTRY_ID),
    foreign key (ENTRY_ID) references OS_WFENTRY(ID) ON DELETE CASCADE
) ENGINE=InnoDB;

drop table if exists OS_CURRENTSTEP_PREV;
create table OS_CURRENTSTEP_PREV
(
    ID bigint NOT NULL,
    PREVIOUS_ID bigint NOT NULL,
    primary key (ID, PREVIOUS_ID),
    index (ID),
    foreign key (ID) references OS_CURRENTSTEP(ID) ON DELETE CASCADE,
    index (PREVIOUS_ID),
    foreign key (PREVIOUS_ID) references OS_HISTORYSTEP(ID) ON DELETE CASCADE
) ENGINE=InnoDB;

drop table if exists OS_HISTORYSTEP_PREV;
create table OS_HISTORYSTEP_PREV
(
    ID bigint NOT NULL,
    PREVIOUS_ID bigint NOT NULL,
    primary key (ID, PREVIOUS_ID),
    index (ID),
    foreign key (ID) references OS_HISTORYSTEP(ID) ON DELETE CASCADE,
    index (PREVIOUS_ID),
    foreign key (PREVIOUS_ID) references OS_HISTORYSTEP(ID) ON DELETE CASCADE
) ENGINE=InnoDB;

drop table if exists OS_STEPIDS;
CREATE TABLE OS_STEPIDS
(
	ID bigint NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (id)
) ENGINE=InnoDB;

drop table if exists OS_ENTRYIDS;
CREATE TABLE OS_ENTRYIDS
(
	ID bigint NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (id)
) ENGINE=InnoDB;

create unique index OS_PROPERTYENTRY_KEYIDX on OS_PROPERTYENTRY (GLOBAL_KEY, ITEM_KEY);
