/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workflow;

import java.net.URL;
import java.util.Collections;
import java.util.Map;

import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowFactory;
import com.opensymphony.workflow.spi.WorkflowStore;
import com.opensymphony.workflow.util.DefaultVariableResolver;
import com.opensymphony.workflow.util.VariableResolver;

/**
 * Really simple OSWorkflow configuration, allowing to setup the WorkflowFactory and the WorkflowStore outside this class.
 */
public class SimpleConfiguration implements Configuration
{
    private WorkflowFactory _factory;

    private WorkflowStore _store;

    /**
     * Constructor.
     * @param factory the WorkflowFactory to manipulate workflow descriptors
     * @param store the WorkflowStore for persisting data
     */
    public SimpleConfiguration(WorkflowFactory factory, WorkflowStore store)
    {
        _factory = factory;
        _store = store;
    }

    public String getPersistence()
    {
        return _store.getClass().getName();
    }

    public Map getPersistenceArgs()
    {
        return Collections.EMPTY_MAP;
    }

    public VariableResolver getVariableResolver()
    {
        return new DefaultVariableResolver();
    }

    public WorkflowDescriptor getWorkflow(String name) throws FactoryException
    {
        return _factory.getWorkflow(name);
    }

    public String[] getWorkflowNames() throws FactoryException
    {
        return _factory.getWorkflowNames();
    }

    public WorkflowStore getWorkflowStore() throws StoreException
    {
        return _store;
    }

    public boolean isInitialized()
    {
        return true;
    }

    public boolean isModifiable(String name)
    {
        return _factory.isModifiable(name);
    }

    public void load(URL url) throws FactoryException
    {
        // empty method
    }

    public boolean removeWorkflow(String workflow) throws FactoryException
    {
        return _factory.removeWorkflow(workflow);
    }

    public boolean saveWorkflow(String name, WorkflowDescriptor descriptor, boolean replace) throws FactoryException
    {
        return _factory.saveWorkflow(name, descriptor, replace);
    }

}
