/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workflow.component;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefaultElementDefinition;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.parameter.DefaultValidator;

/**
 * Class for creating model item for workflow function or condition argument
 */
public class WorkflowArgument extends DefaultElementDefinition 
{
    
    /**
     * Constructor for workflow argument
     * @param name name of model item
     * @param type model item type
     * @param label label key for model item
     * @param description description key for model item
     * @param isMandatory if model item has to be filled
     * @param isMultiple if the model item accept multiple values
     */
    @SuppressWarnings("unchecked")
    public WorkflowArgument(String name, ElementType type, I18nizableText label, I18nizableText description, boolean isMandatory, boolean isMultiple)
    {
        super(name, isMultiple, type);
        setLabel(label);
        setDescription(description);
        setValidator(new DefaultValidator(null, isMandatory));
    }
}
