/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workflow.support;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.plugins.workflow.ModelItemTypeExtensionPoint;
import org.ametys.plugins.workflow.component.WorkflowArgument;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.type.ElementType;

/**
 * Helper to create element definition for workflow
 */
public class WorkflowElementDefinitionHelper implements Serviceable, Component
{
    /** The model item type extension point */
    protected static ModelItemTypeExtensionPoint _modelItemDataTypeEP;
    
    private static final String __WORKFLOW_ARGUMENT_DATA_TYPE_STRING = "string";
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _modelItemDataTypeEP = (ModelItemTypeExtensionPoint) manager.lookup(ModelItemTypeExtensionPoint.ROLE_WORKFLOW);
    }

    /**
     * Create element definition
     * @param name the name
     * @param label the label i18n key. Can be null.
     * @param description the desc i18n key. Can be null.
     * @param isMandatory if model item has to be filled
     * @param isMultiple if the model item accept multiple values
     * @return the element definition
     */
    public static WorkflowArgument getElementDefinition(String name, I18nizableText label, I18nizableText description, boolean isMandatory, boolean isMultiple)
    {
        ElementType type = (ElementType) _modelItemDataTypeEP.getExtension(__WORKFLOW_ARGUMENT_DATA_TYPE_STRING);
        return new WorkflowArgument(name, type, label, description, isMandatory, isMultiple);
    }
}
