/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow;

import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractWorkflowComponent
implements LogEnabled,
Serviceable {
    public static final String CONTEXT_PARAMETERS_KEY = AbstractWorkflowComponent.class.getName() + "$Parameters";
    public static final String RESULT_MAP_KEY = AbstractWorkflowComponent.class.getName() + ";resultMap";
    public static final String FAIL_CONDITIONS_KEY = AbstractWorkflowComponent.class.getName() + "$failConditions";
    public static final String WORKFLOW_VALIDATION_KEY = "workflowValidation";
    protected ServiceManager _manager;
    protected Logger _logger;

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    public UserIdentity getUser(Map transientVars) throws WorkflowException {
        WorkflowContext workflowContext = (WorkflowContext)transientVars.get("context");
        if (workflowContext == null) {
            throw new WorkflowException("Unable to get the workflow context");
        }
        return UserIdentity.stringToUserIdentity((String)workflowContext.getCaller());
    }

    public Map<String, Object> getContextParameters(Map transientVars) {
        return Optional.ofNullable(transientVars.get(CONTEXT_PARAMETERS_KEY)).filter(Map.class::isInstance).map(Map.class::cast).orElseGet(() -> new HashMap());
    }

    public List<ConditionFailure> getConditionFailures(Map transientVars) {
        return (List)transientVars.get(FAIL_CONDITIONS_KEY);
    }

    public Map<String, Object> getResultsMap(Map transientVars) throws WorkflowException {
        Map resultMap = (Map)transientVars.get(RESULT_MAP_KEY);
        if (resultMap == null) {
            throw new WorkflowException("Unable to retrieve result map");
        }
        return resultMap;
    }

    public void addWorkflowError(Map transientVars, I18nizableText errorLabel) throws WorkflowException {
        Map<String, Object> resultMap = this.getResultsMap(transientVars);
        ValidationResult validationResult = (ValidationResult)resultMap.computeIfAbsent(WORKFLOW_VALIDATION_KEY, __ -> new ValidationResult());
        validationResult.addError(errorLabel);
    }

    public void addWorkflowWarning(Map transientVars, I18nizableText warnLabel) throws WorkflowException {
        Map<String, Object> resultMap = this.getResultsMap(transientVars);
        ValidationResult validationResult = (ValidationResult)resultMap.computeIfAbsent(WORKFLOW_VALIDATION_KEY, __ -> new ValidationResult());
        validationResult.addWarning(warnLabel);
    }

    public record ConditionFailure(String text, String type) {
    }
}

