/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow;

import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.Expression;
import com.opensymphony.workflow.query.NestedExpression;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.plugins.workflow.PropertySetExpression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCPropertySet
extends com.opensymphony.module.propertyset.database.JDBCPropertySet {
    public static final String OSWF_PREFIX = "oswf_";
    private static final String __TABLE_NAME = "OS_PROPERTYENTRY";
    private static final String __GLOBAL_KEY_COL = "GLOBAL_KEY";
    private static final String __ITEM_KEY_COL = "ITEM_KEY";
    private static final String __ITEM_TYPE_COL = "ITEM_TYPE";
    private static final String __STRING_COL = "STRING_VALUE";
    private static Log __log = LogFactory.getLog(JDBCPropertySet.class);
    protected DataSource _ds;

    public void init(Map config, Map args) {
        this.globalKey = (String)args.get("globalKey");
        this._ds = (DataSource)config.get("datasource");
        this.tableName = __TABLE_NAME;
        this.colGlobalKey = __GLOBAL_KEY_COL;
        this.colItemKey = __ITEM_KEY_COL;
        this.colItemType = __ITEM_TYPE_COL;
        this.colString = __STRING_COL;
        this.colDate = "DATE_VALUE";
        this.colData = "DATA_VALUE";
        this.colFloat = "FLOAT_VALUE";
        this.colNumber = "NUMBER_VALUE";
    }

    protected Connection getConnection() throws SQLException {
        this.closeConnWhenDone = true;
        return this._ds.getConnection();
    }

    protected void cleanup(Connection connection, Statement statement, ResultSet result) {
        ConnectionHelper.cleanup((ResultSet)result);
        ConnectionHelper.cleanup((Statement)statement);
        if (this.closeConnWhenDone) {
            ConnectionHelper.cleanup((Connection)connection);
        }
    }

    public static boolean isPropertySetExpressionsNested(NestedExpression expr) throws StoreException {
        int count = expr.getExpressionCount();
        for (int i = 0; i < count; ++i) {
            Expression e = expr.getExpression(i);
            if (!(e instanceof NestedExpression ? !JDBCPropertySet.isPropertySetExpressionsNested((NestedExpression)e) : !(e instanceof PropertySetExpression))) continue;
            return false;
        }
        return true;
    }

    public static List query(DataSource ds, Expression e) throws StoreException {
        LinkedList<String> values = new LinkedList<String>();
        StringBuffer query = new StringBuffer();
        query.append("SELECT DISTINCT ");
        query.append(__GLOBAL_KEY_COL);
        query.append(" FROM ");
        query.append(__TABLE_NAME);
        query.append(" WHERE ");
        query.append(JDBCPropertySet._getCondition(ds, e, values));
        return JDBCPropertySet.__doExpressionQuery(ds, query.toString(), values);
    }

    private static String _getCondition(DataSource ds, Expression e, List<String> values) throws StoreException {
        if (e instanceof NestedExpression) {
            NestedExpression nestedExpr = (NestedExpression)e;
            int operator = nestedExpr.getExpressionOperator();
            if (operator != 6 && operator != 7) {
                throw new StoreException("Invalid nested operator " + operator);
            }
            StringBuffer condition = new StringBuffer();
            if (nestedExpr.isNegate()) {
                condition.append("NOT ");
            }
            condition.append("(");
            int count = nestedExpr.getExpressionCount();
            for (int i = 0; i < count; ++i) {
                Expression expr = nestedExpr.getExpression(i);
                condition.append(JDBCPropertySet._getCondition(ds, expr, values));
                if (i + 1 == count) continue;
                if (operator == 6) {
                    condition.append(" AND ");
                    continue;
                }
                condition.append(" OR ");
            }
            condition.append(")");
            return condition.toString();
        }
        if (e instanceof PropertySetExpression) {
            return JDBCPropertySet._getCondition((PropertySetExpression)e, values);
        }
        throw new StoreException("Unsupported expression with mixed expressions");
    }

    private static String _getCondition(PropertySetExpression e, List<String> values) throws StoreException {
        String columnName;
        String value = null;
        if (e.getType() == 5) {
            columnName = __STRING_COL;
            if (!(e.getValue() instanceof String)) {
                throw new StoreException("Query with value: " + String.valueOf(e.getValue().getClass()) + " is not supported");
            }
        } else {
            throw new StoreException("Query of type: " + e.getType() + " is not supported");
        }
        value = (String)e.getValue();
        StringBuffer query = new StringBuffer("(");
        query.append(__ITEM_KEY_COL);
        query.append(" = ? AND ");
        query.append(columnName);
        switch (e.getOperator()) {
            case 1: {
                if (e.isNegate()) {
                    query.append(" <> ");
                    break;
                }
                query.append(" = ");
                break;
            }
            case 2: {
                if (e.isNegate()) {
                    query.append(" NOT LIKE ");
                } else {
                    query.append(" LIKE ");
                }
                value = value.replace('*', '%');
                break;
            }
            default: {
                throw new StoreException("Query with operator: " + e.getOperator() + " is not supported");
            }
        }
        query.append("?)");
        values.add(e.getKey());
        values.add(value);
        return query.toString();
    }

    private static List __doExpressionQuery(DataSource ds, String query, List values) throws StoreException {
        ArrayList<Long> workflowID2;
        ArrayList<Long> results = new ArrayList<Long>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ds.getConnection();
            stmt = con.prepareStatement(query);
            for (int i = 0; i < values.size(); ++i) {
                stmt.setObject(i + 1, values.get(i));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Query is: " + query + "\n" + String.valueOf(values)));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long workflowID2 = JDBCPropertySet.__getWorkflowID(rs.getString(1));
                if (workflowID2 == null) continue;
                results.add(workflowID2);
            }
            workflowID2 = results;
        }
        catch (SQLException ex) {
            try {
                throw new StoreException("SQL Exception in query: " + query, (Throwable)ex);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup((Connection)con);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup((ResultSet)rs);
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)con);
        return workflowID2;
    }

    private static Long __getWorkflowID(String globalKey) {
        if (globalKey == null) {
            return null;
        }
        if (globalKey.startsWith(OSWF_PREFIX)) {
            return Long.valueOf(globalKey.substring(OSWF_PREFIX.length()));
        }
        return null;
    }
}

