/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.dao;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.workflow.dao.WorkflowStepDAO;
import org.ametys.plugins.workflow.dao.WorkflowTransitionDAO;
import org.ametys.plugins.workflow.support.WorflowRightHelper;
import org.ametys.plugins.workflow.support.WorkflowSessionHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class WorkflowPropertyDAO
extends AbstractLogEnabled
implements Component,
Serviceable {
    protected WorkflowSessionHelper _workflowSessionHelper;
    protected WorflowRightHelper _workflowRightHelper;
    protected WorkflowStepDAO _workflowStepDAO;
    protected WorkflowTransitionDAO _workflowTransitionDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        this._workflowSessionHelper = (WorkflowSessionHelper)((Object)smanager.lookup(WorkflowSessionHelper.ROLE));
        this._workflowRightHelper = (WorflowRightHelper)smanager.lookup(WorflowRightHelper.ROLE);
        this._workflowStepDAO = (WorkflowStepDAO)((Object)smanager.lookup(WorkflowStepDAO.ROLE));
        this._workflowTransitionDAO = (WorkflowTransitionDAO)smanager.lookup(WorkflowTransitionDAO.ROLE);
    }

    @Callable(rights={""})
    public Map<String, Object> getStepProperties(String workflowName, Integer stepId) {
        StepDescriptor step;
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        ArrayList<Map<String, Object>> properties2json = new ArrayList<Map<String, Object>>();
        if (this._workflowRightHelper.canRead(workflowDescriptor) && (step = workflowDescriptor.getStep(stepId.intValue())) != null) {
            properties2json.addAll(this._properties2JSON(step.getMetaAttributes()));
        }
        return Map.of("data", properties2json);
    }

    @Callable(rights={""})
    public Map<String, Object> getActionProperties(String workflowName, Integer actionId) {
        ActionDescriptor action;
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        ArrayList<Map<String, Object>> propertiesToJson = new ArrayList<Map<String, Object>>();
        if (this._workflowRightHelper.canRead(workflowDescriptor) && (action = workflowDescriptor.getAction(actionId.intValue())) != null) {
            propertiesToJson.addAll(this._properties2JSON(action.getMetaAttributes()));
        }
        return Map.of("data", propertiesToJson);
    }

    private List<Map<String, Object>> _properties2JSON(Map<String, Object> metaAttributes) {
        ArrayList<Map<String, Object>> propertiesToJson = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Object> entry : metaAttributes.entrySet()) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("id", entry.getKey());
            properties.put("value", entry.getValue());
            propertiesToJson.add(properties);
        }
        return propertiesToJson;
    }

    @Callable(rights={""})
    public Set<String> getPropertiesNames(String workflowName, Integer stepId, Integer actionId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        Map<String, Object> properties = this._getProperties(workflowDescriptor, stepId, actionId);
        return properties.keySet();
    }

    @Callable(rights={""})
    public Map<String, Object> addProperty(String workflowName, Integer stepId, Integer actionId, String name, String value) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        if (StringUtils.isBlank((CharSequence)name)) {
            return Map.of("message", "blank-name");
        }
        Map<String, Object> properties = this._getProperties(workflowDescriptor, stepId, actionId);
        if (properties.get(name) != null) {
            return Map.of("message", "duplicate-name");
        }
        properties.put(name, value);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getPropertiesInfos(workflowDescriptor, stepId, actionId, name, value, true);
    }

    @Callable(rights={""})
    public Map<String, Object> editProperty(String workflowName, Integer stepId, Integer actionId, String oldName, String newName, String newValue) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        if (StringUtils.isBlank((CharSequence)newName)) {
            return Map.of("message", "blank-name");
        }
        Map<String, Object> properties = this._getProperties(workflowDescriptor, stepId, actionId);
        if (StringUtils.isNotBlank((CharSequence)oldName) && !oldName.equals(newName)) {
            properties.remove(oldName);
        }
        properties.put(newName, newValue);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getPropertiesInfos(workflowDescriptor, stepId, actionId, newName, newValue, true);
    }

    @Callable(rights={""})
    public Map<String, Object> deleteProperty(String workflowName, Integer stepId, Integer actionId, String name) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        if (StringUtils.isBlank((CharSequence)name)) {
            return Map.of("message", "blank-name");
        }
        Map<String, Object> properties = this._getProperties(workflowDescriptor, stepId, actionId);
        properties.remove(name);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getPropertiesInfos(workflowDescriptor, stepId, actionId, name, null, true);
    }

    private Map<String, Object> _getProperties(WorkflowDescriptor workflowDescriptor, Integer stepId, Integer actionId) {
        HashMap<String, Object> metaAttributes = new HashMap();
        if (actionId == null) {
            StepDescriptor step = workflowDescriptor.getStep(stepId.intValue());
            metaAttributes = step.getMetaAttributes();
        } else {
            ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
            metaAttributes = action.getMetaAttributes();
        }
        return metaAttributes;
    }

    private Map<String, Object> _getPropertiesInfos(WorkflowDescriptor workflow, Integer stepId, Integer actionId, String name, String value, boolean hasChanges) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("workflowId", workflow.getName());
        results.put("hasChanges", hasChanges);
        results.put("stepId", stepId);
        results.put("stepLabel", this._workflowStepDAO.getStepLabel(workflow, stepId));
        if (actionId != null) {
            ActionDescriptor action = workflow.getAction(actionId.intValue());
            results.put("actionId", actionId);
            results.put("actionLabel", this._workflowTransitionDAO.getActionLabel(action));
        }
        results.put("name", name);
        results.put("value", value);
        return results;
    }
}

