/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.dao;

import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.workflow.dao.WorkflowStepDAO;
import org.ametys.plugins.workflow.dao.WorkflowTransitionDAO;
import org.ametys.plugins.workflow.support.WorflowRightHelper;
import org.ametys.plugins.workflow.support.WorkflowSessionHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class WorkflowResultDAO
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = WorkflowResultDAO.class.getName();
    protected WorkflowSessionHelper _workflowSessionHelper;
    protected WorflowRightHelper _workflowRightHelper;
    protected WorkflowStepDAO _workflowStepDAO;
    protected WorkflowTransitionDAO _workflowTransitionDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._workflowSessionHelper = (WorkflowSessionHelper)((Object)manager.lookup(WorkflowSessionHelper.ROLE));
        this._workflowRightHelper = (WorflowRightHelper)manager.lookup(WorflowRightHelper.ROLE);
        this._workflowStepDAO = (WorkflowStepDAO)((Object)manager.lookup(WorkflowStepDAO.ROLE));
        this._workflowTransitionDAO = (WorkflowTransitionDAO)manager.lookup(WorkflowTransitionDAO.ROLE);
    }

    @Callable(rights={""})
    public Map<String, Object> getConditionalResultsToJson(String workflowName, Integer actionId, Integer currentStepId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkReadRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        ArrayList<Integer> usedSteps = new ArrayList<Integer>();
        usedSteps.add(action.getUnconditionalResult().getStep());
        List conditionalResults = action.getConditionalResults();
        for (ConditionalResultDescriptor result : conditionalResults) {
            usedSteps.add(result.getStep());
        }
        List workflowStatesToJson = (List)this._workflowStepDAO.getStatesToJson(workflowName, actionId, workflowDescriptor.getInitialAction(actionId.intValue()) != null).get("data");
        ArrayList<Map> states = new ArrayList<Map>();
        for (int i = 0; i < workflowStatesToJson.size(); ++i) {
            Map state = (Map)workflowStatesToJson.get(i);
            Integer id = (Integer)state.get("id");
            if (usedSteps.contains(id)) continue;
            states.add(state);
        }
        if (currentStepId != null) {
            HashMap<String, Object> stateInfos = new HashMap<String, Object>();
            stateInfos.put("id", currentStepId);
            boolean showId = currentStepId != -1;
            stateInfos.put("label", this._workflowStepDAO.getStepLabelAsString(workflowDescriptor, currentStepId, showId));
            states.add(stateInfos);
        }
        return Map.of("data", states);
    }

    @Callable(rights={""})
    public Map<String, Object> addConditionalResult(String workflowName, Integer stepId, Integer actionId, Integer resultId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        List conditionalResults = action.getConditionalResults();
        Optional<ConditionalResultDescriptor> sameFinalState = conditionalResults.stream().filter(cr -> cr.getStep() == resultId.intValue()).findAny();
        if (sameFinalState.isPresent()) {
            return Map.of("message", "duplicate-state");
        }
        DescriptorFactory factory = new DescriptorFactory();
        ConditionalResultDescriptor resultDescriptor = factory.createConditionalResultDescriptor();
        resultDescriptor.setStep(resultId.intValue());
        conditionalResults.add(resultDescriptor);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getResultProperties(workflowDescriptor, action, stepId, resultId);
    }

    @Callable(rights={""})
    public Map<String, Object> editConditionalResult(String workflowName, Integer stepId, Integer actionId, Integer resultOldId, Integer resultNewId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        List conditionalResults = action.getConditionalResults();
        int indexOf = this.getIndexOfStepResult(conditionalResults, resultOldId);
        if (indexOf != -1) {
            ((ConditionalResultDescriptor)conditionalResults.get(indexOf)).setStep(resultNewId.intValue());
        }
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getResultProperties(workflowDescriptor, action, stepId, resultNewId);
    }

    @Callable(rights={""})
    public Map<String, Object> deleteConditionalResult(String workflowName, Integer stepId, Integer actionId, Integer resultId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        List conditionalResults = action.getConditionalResults();
        int indexOf = this.getIndexOfStepResult(conditionalResults, resultId);
        if (indexOf != -1) {
            conditionalResults.remove(indexOf);
        }
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getResultProperties(workflowDescriptor, action, stepId, resultId);
    }

    private Map<String, Object> _getResultProperties(WorkflowDescriptor workflowDescriptor, ActionDescriptor action, Integer stepId, Integer resultId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("nodeId", "step" + resultId);
        results.put("nodeLabel", this._workflowStepDAO.getStepLabel(workflowDescriptor, resultId));
        results.put("actionId", action.getId());
        results.put("actionLabel", this._workflowTransitionDAO.getActionLabel(action));
        results.put("stepId", stepId);
        results.put("stepLabel", this._workflowStepDAO.getStepLabel(workflowDescriptor, stepId));
        results.put("workflowId", workflowDescriptor.getName());
        results.put("isConditional", true);
        return results;
    }

    protected List<AbstractDescriptor> getChildrenResultConditions(String currentNode, ActionDescriptor action, List<ConditionalResultDescriptor> conditionalResults) {
        String[] path;
        int stepId;
        List<ConditionsDescriptor> resultConditions;
        if (!conditionalResults.isEmpty() && !(resultConditions = this.getRootResultConditions(conditionalResults, stepId = Integer.valueOf((path = this.getPath(currentNode))[0].substring(4)).intValue())).isEmpty()) {
            ConditionsDescriptor rootConditionsDescriptor = resultConditions.get(0);
            if (path.length == 1 && rootConditionsDescriptor.getType().equals("OR")) {
                return List.of(rootConditionsDescriptor);
            }
            if (path.length == 1) {
                return rootConditionsDescriptor.getConditions();
            }
            if (!path[path.length - 1].startsWith("condition")) {
                ArrayList<AbstractDescriptor> conditions = new ArrayList<ConditionsDescriptor>();
                conditions.add((AbstractDescriptor)rootConditionsDescriptor);
                if (!conditions.isEmpty()) {
                    int i = 1;
                    do {
                        String currentOrAndConditionId;
                        int currentOrAndConditionIndex = (currentOrAndConditionId = path[i]).startsWith("and") ? Integer.valueOf(currentOrAndConditionId.substring(3)) : Integer.valueOf(currentOrAndConditionId.substring(2));
                        ConditionsDescriptor currentOrAndCondition = (ConditionsDescriptor)conditions.get(currentOrAndConditionIndex);
                        conditions = currentOrAndCondition.getConditions();
                    } while (++i < path.length);
                    return conditions;
                }
            }
        }
        return List.of();
    }

    public String[] getPath(String currentNodeId) {
        String[] path = currentNodeId.split("-");
        if (path.length > 1 && path[1].equals("1")) {
            path[0] = path[0] + "-1";
            String[] copyArray = new String[path.length - 1];
            copyArray[0] = path[0];
            System.arraycopy(path, 2, copyArray, 1, path.length - 2);
            path = copyArray;
        }
        return path;
    }

    public List<ConditionsDescriptor> getRootResultConditions(List<ConditionalResultDescriptor> conditionalResults, int stepId) {
        return conditionalResults.stream().filter(r -> r.getStep() == stepId).map(r -> r.getConditions()).findFirst().orElse(List.of());
    }

    public int getIndexOfStepResult(List<ConditionalResultDescriptor> conditionalResults, Integer stepResultId) {
        for (int i = 0; i < conditionalResults.size(); ++i) {
            if (conditionalResults.get(i).getStep() != stepResultId.intValue()) continue;
            return i;
        }
        return -1;
    }
}

