/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.store;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.Expression;
import com.opensymphony.workflow.query.NestedExpression;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.spi.jdbc.JDBCWorkflowStore;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.ametys.plugins.workflow.JDBCPropertySet;
import org.ametys.plugins.workflow.PropertySetExpression;
import org.ametys.plugins.workflow.store.AmetysWorkflowStore;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcWorkflowStore
extends JDBCWorkflowStore
implements AmetysWorkflowStore,
Component,
Serviceable,
Configurable,
Initializable,
Disposable {
    public static final String ROLE = JdbcWorkflowStore.class.getName();
    protected Logger _logger = LoggerFactory.getLogger(JdbcWorkflowStore.class);
    protected SQLDataSourceManager _sqlDataSourceManager;
    protected String _dataSourceId;
    protected String _databaseType;
    protected String _entrySequenceIncrement;
    protected String _entrySequenceRetrieve;
    protected String _stepSequenceIncrement;
    protected String _stepSequenceRetrieve;

    public void service(ServiceManager manager) throws ServiceException {
        this._sqlDataSourceManager = (SQLDataSourceManager)manager.lookup(SQLDataSourceManager.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration dataSourceConf = configuration.getChild("datasource", true);
        String dataSourceConfParam = dataSourceConf.getValue();
        String dataSourceConfType = dataSourceConf.getAttribute("type", "config");
        this._dataSourceId = Strings.CS.equals(dataSourceConfType, "config") ? (String)Config.getInstance().getValue(dataSourceConfParam) : dataSourceConfParam;
    }

    public void initialize() throws Exception {
        this.ds = this._sqlDataSourceManager.getSQLDataSource(this._dataSourceId);
        if (this.ds == null) {
            throw new ConfigurationException("Invalid datasource id: " + this._dataSourceId);
        }
        this.init(Collections.EMPTY_MAP);
    }

    public void dispose() {
        this._dataSourceId = null;
        this.ds = null;
    }

    public void init(Map props) throws StoreException {
        String databaseType;
        this.entryTable = "OS_WFENTRY";
        this.entryId = "ID";
        this.entryName = "NAME";
        this.entryState = "STATE";
        this.historyTable = "OS_HISTORYSTEP";
        this.historyPrevTable = "OS_HISTORYSTEP_PREV";
        this.currentTable = "OS_CURRENTSTEP";
        this.currentPrevTable = "OS_CURRENTSTEP_PREV";
        this.stepId = "ID";
        this.stepEntryId = "ENTRY_ID";
        this.stepStepId = "STEP_ID";
        this.stepActionId = "ACTION_ID";
        this.stepOwner = "OWNER";
        this.stepCaller = "CALLER";
        this.stepStartDate = "START_DATE";
        this.stepFinishDate = "FINISH_DATE";
        this.stepDueDate = "DUE_DATE";
        this.stepStatus = "STATUS";
        this.stepPreviousId = "PREVIOUS_ID";
        try {
            databaseType = this.getDatabaseType();
        }
        catch (SQLException e) {
            throw new StoreException("Unable to retrieve database type", (Throwable)e);
        }
        if ("mysql".equals(databaseType)) {
            this._entrySequenceIncrement = "INSERT INTO OS_ENTRYIDS (ID) values (null)";
            this._entrySequenceRetrieve = "SELECT LAST_INSERT_ID()";
            this._stepSequenceIncrement = "INSERT INTO OS_STEPIDS (ID) values (null)";
            this._stepSequenceRetrieve = "SELECT LAST_INSERT_ID()";
        } else if ("derby".equals(databaseType)) {
            this._entrySequenceIncrement = "INSERT INTO OS_ENTRYIDS values (DEFAULT)";
            this._entrySequenceRetrieve = "VALUES IDENTITY_VAL_LOCAL()";
            this._stepSequenceIncrement = "INSERT INTO OS_STEPIDS values (DEFAULT)";
            this._stepSequenceRetrieve = "VALUES IDENTITY_VAL_LOCAL()";
        } else if ("postgresql".equals(databaseType)) {
            this.entrySequence = "SELECT nextval('seq_os_wfentry')";
            this.stepSequence = "SELECT nextval('seq_os_currentsteps')";
        } else if ("oracle".equals(databaseType)) {
            this.entrySequence = "SELECT seq_os_wfentry.nextval from dual";
            this.stepSequence = "SELECT seq_os_currentsteps.nextval from dual";
        } else if ("hsqldb".equals(databaseType)) {
            this.entrySequence = "call next value for seq_os_wfentry";
            this.stepSequence = "call next value for seq_os_currentsteps";
        } else {
            throw new IllegalArgumentException(String.format("Unsupported database type '%s'", databaseType));
        }
    }

    public String getDatabaseType() throws SQLException {
        if (this._databaseType == null) {
            try (Connection connection = this.getConnection();){
                this._databaseType = ConnectionHelper.getDatabaseType((Connection)connection);
            }
        }
        return this._databaseType;
    }

    public PropertySet getPropertySet(long id) {
        HashMap<String, CallSite> args = new HashMap<String, CallSite>(1);
        args.put("globalKey", (CallSite)((Object)("oswf_" + id)));
        HashMap<String, DataSource> config = new HashMap<String, DataSource>(1);
        config.put("datasource", this.ds);
        JDBCPropertySet ps = new JDBCPropertySet();
        ps.init(config, args);
        return ps;
    }

    @Override
    public boolean shouldClearHistory() {
        return true;
    }

    protected void cleanup(Connection connection, Statement statement, ResultSet result) {
        ConnectionHelper.cleanup((ResultSet)result);
        ConnectionHelper.cleanup((Statement)statement);
        if (this.closeConnWhenDone) {
            ConnectionHelper.cleanup((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInstance(long idWorkflow) {
        Connection c = null;
        PreparedStatement stmt = null;
        try {
            c = this.getConnection();
            String sql = "DELETE FROM " + this.entryTable + " WHERE " + this.entryId + " = ?";
            stmt = c.prepareStatement(sql);
            stmt.setLong(1, idWorkflow);
            this._logger.debug(sql);
            if (stmt.executeUpdate() != 1) {
                this._logger.error("Unable to remove a workflow instance in database");
            }
            this.cleanup(c, stmt, null);
        }
        catch (SQLException ex) {
            try {
                this._logger.error("Error while removing a workflow instance", (Throwable)ex);
                this.cleanup(c, stmt, null);
            }
            catch (Throwable throwable) {
                this.cleanup(c, stmt, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearHistory(long idWorkflow) {
        Connection c = null;
        PreparedStatement stmt = null;
        try {
            c = this.getConnection();
            String sql = "DELETE FROM " + this.historyTable + " WHERE " + this.stepEntryId + " = ?";
            stmt = c.prepareStatement(sql);
            stmt.setLong(1, idWorkflow);
            this._logger.debug(sql);
            stmt.executeUpdate();
            this.cleanup(c, stmt, null);
        }
        catch (SQLException e) {
            try {
                this._logger.error("Error while clearing history steps from an workflow instance", (Throwable)e);
                this.cleanup(c, stmt, null);
            }
            catch (Throwable throwable) {
                this.cleanup(c, stmt, null);
                throw throwable;
            }
        }
    }

    public List query(WorkflowExpressionQuery e) throws StoreException {
        Expression expression = e.getExpression();
        if (expression instanceof PropertySetExpression) {
            return JDBCPropertySet.query(this.ds, expression);
        }
        if (expression instanceof NestedExpression) {
            NestedExpression expr = (NestedExpression)expression;
            if (JDBCPropertySet.isPropertySetExpressionsNested(expr)) {
                return JDBCPropertySet.query(this.ds, expression);
            }
            return super.query(e);
        }
        return super.query(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextEntrySequence(Connection c) throws SQLException {
        String databaseType = this.getDatabaseType();
        if ("mysql".equals(databaseType) || "derby".equals(databaseType)) {
            PreparedStatement stmt = null;
            ResultSet rset = null;
            try {
                long id;
                stmt = c.prepareStatement(this._entrySequenceIncrement);
                stmt.executeUpdate();
                rset = c.createStatement().executeQuery(this._entrySequenceRetrieve);
                rset.next();
                long l = id = rset.getLong(1);
                this.cleanup(null, stmt, rset);
                return l;
            }
            catch (Throwable throwable) {
                this.cleanup(null, stmt, rset);
                throw throwable;
            }
        }
        return super.getNextEntrySequence(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextStepSequence(Connection c) throws SQLException {
        String databaseType = this.getDatabaseType();
        if ("mysql".equals(databaseType) || "derby".equals(databaseType)) {
            PreparedStatement stmt = null;
            ResultSet rset = null;
            try {
                long id;
                stmt = c.prepareStatement(this._stepSequenceIncrement);
                stmt.executeUpdate();
                rset = c.createStatement().executeQuery(this._stepSequenceRetrieve);
                rset.next();
                long l = id = rset.getLong(1);
                this.cleanup(null, stmt, rset);
                return l;
            }
            catch (Throwable throwable) {
                this.cleanup(null, stmt, rset);
                throw throwable;
            }
        }
        return super.getNextEntrySequence(c);
    }
}

