--
--  Copyright 2009 Anyware Services
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
--

DROP TABLE OS_PROPERTYENTRY IF EXISTS;
DROP TABLE OS_CURRENTSTEP_PREV IF EXISTS;
DROP TABLE OS_HISTORYSTEP_PREV IF EXISTS;
DROP TABLE OS_CURRENTSTEP IF EXISTS;
DROP TABLE OS_HISTORYSTEP IF EXISTS;
DROP TABLE OS_WFENTRY IF EXISTS;
DROP SEQUENCE SEQ_OS_WFENTRY IF EXISTS;
DROP SEQUENCE SEQ_OS_CURRENTSTEPS IF EXISTS;

CREATE CACHED TABLE OS_PROPERTYENTRY
(
    GLOBAL_KEY VARCHAR(250) NOT NULL,
    ITEM_KEY VARCHAR(250) NOT NULL,
    ITEM_TYPE SMALLINT,
    STRING_VALUE VARCHAR(255),
    DATE_VALUE TIMESTAMP,
    DATA_VALUE LONGVARBINARY,
    FLOAT_VALUE FLOAT,
    NUMBER_VALUE NUMERIC,
    PRIMARY KEY (GLOBAL_KEY, ITEM_KEY)
);

CREATE CACHED TABLE OS_WFENTRY
(
    ID BIGINT NOT NULL,
    NAME VARCHAR(255),
    STATE INTEGER,
    PRIMARY KEY (ID)
);

CREATE CACHED TABLE OS_CURRENTSTEP
(
    ID BIGINT NOT NULL,
    ENTRY_ID BIGINT,
    STEP_ID INTEGER,
    ACTION_ID INTEGER,
    OWNER VARCHAR(200),
    START_DATE TIMESTAMP,
    FINISH_DATE TIMESTAMP,
    DUE_DATE TIMESTAMP,
    STATUS VARCHAR(40),
    CALLER VARCHAR(200),

    PRIMARY KEY (ID),
    FOREIGN KEY (ENTRY_ID) REFERENCES OS_WFENTRY(ID) ON DELETE CASCADE
);

CREATE CACHED TABLE OS_HISTORYSTEP
(
    ID BIGINT NOT NULL,
    ENTRY_ID BIGINT,
    STEP_ID INTEGER,
    ACTION_ID INTEGER,
    OWNER VARCHAR(200),
    START_DATE TIMESTAMP,
    FINISH_DATE TIMESTAMP,
    DUE_DATE TIMESTAMP,
    STATUS VARCHAR(40),
    CALLER VARCHAR(200),

    PRIMARY KEY (ID),
    FOREIGN KEY (ENTRY_ID) REFERENCES OS_WFENTRY(ID) ON DELETE CASCADE
);

CREATE CACHED TABLE OS_CURRENTSTEP_PREV
(
    ID BIGINT NOT NULL,
    PREVIOUS_ID BIGINT NOT NULL,
    PRIMARY KEY (ID, PREVIOUS_ID),
    FOREIGN KEY (ID) REFERENCES OS_CURRENTSTEP(ID) ON DELETE CASCADE,
    FOREIGN KEY (PREVIOUS_ID) REFERENCES OS_HISTORYSTEP(ID) ON DELETE CASCADE
);

CREATE CACHED TABLE OS_HISTORYSTEP_PREV
(
    ID BIGINT NOT NULL,
    PREVIOUS_ID BIGINT NOT NULL,
    PRIMARY KEY (ID, PREVIOUS_ID),
    FOREIGN KEY (ID) REFERENCES OS_HISTORYSTEP(ID) ON DELETE CASCADE,
    FOREIGN KEY (PREVIOUS_ID) REFERENCES OS_HISTORYSTEP(ID) ON DELETE CASCADE
);

CREATE SEQUENCE SEQ_OS_WFENTRY AS BIGINT START WITH 1 INCREMENT BY 1;
CREATE SEQUENCE SEQ_OS_CURRENTSTEPS AS BIGINT START WITH 1 INCREMENT BY 1;

