--
--  Copyright 2009 Anyware Services
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
--
DROP TABLE IF EXISTS OS_PROPERTYENTRY;
DROP TABLE IF EXISTS OS_CURRENTSTEP_PREV;
DROP TABLE IF EXISTS OS_HISTORYSTEP_PREV ;
DROP TABLE IF EXISTS OS_CURRENTSTEP;
DROP TABLE IF EXISTS OS_HISTORYSTEP;
DROP TABLE IF EXISTS OS_WFENTRY;
DROP SEQUENCE IF EXISTS seq_os_wfentry;
DROP SEQUENCE IF EXISTS seq_os_currentsteps;


create table OS_PROPERTYENTRY
(
	GLOBAL_KEY varchar(255),
	ITEM_KEY varchar(255),
	ITEM_TYPE smallint,
	STRING_VALUE varchar(255),
	DATE_VALUE timestamp,
	DATA_VALUE bytea,
	FLOAT_VALUE float8,
	NUMBER_VALUE numeric,
	primary key (GLOBAL_KEY, ITEM_KEY)
);

create table OS_WFENTRY
(
    ID bigint,
    NAME varchar(255),
    STATE smallint,
    primary key (ID)
);

create table OS_CURRENTSTEP
(
    ID bigint,
    ENTRY_ID bigint,
    STEP_ID smallint,
    ACTION_ID smallint,
    OWNER varchar(200),
    START_DATE timestamp,
    FINISH_DATE timestamp,
    DUE_DATE timestamp,
    STATUS varchar(40),
    CALLER varchar(200),
    primary key (ID),
    foreign key (ENTRY_ID) references OS_WFENTRY(ID) ON DELETE CASCADE
);

create table OS_HISTORYSTEP
(
    ID bigint,
    ENTRY_ID bigint,
    STEP_ID smallint,
    ACTION_ID smallint,
    OWNER varchar(200),
    START_DATE timestamp,
    FINISH_DATE timestamp,
    DUE_DATE timestamp,
    STATUS varchar(40),
    CALLER varchar(200),
    primary key (ID),
    foreign key (ENTRY_ID) references OS_WFENTRY(ID) ON DELETE CASCADE
);

create table OS_CURRENTSTEP_PREV
(
    ID bigint,
    PREVIOUS_ID bigint,
    primary key (ID, PREVIOUS_ID),
    foreign key (ID) references OS_CURRENTSTEP(ID) ON DELETE CASCADE,
    foreign key (PREVIOUS_ID) references OS_HISTORYSTEP(ID) ON DELETE CASCADE
);

create table OS_HISTORYSTEP_PREV
(
    ID bigint,
    PREVIOUS_ID bigint,
    primary key (ID, PREVIOUS_ID),
    foreign key (ID) references OS_HISTORYSTEP(ID) ON DELETE CASCADE,
    foreign key (PREVIOUS_ID) references OS_HISTORYSTEP(ID) ON DELETE CASCADE
);

create sequence seq_os_wfentry minvalue 10 increment 10;
create sequence seq_os_currentsteps;