/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workflow.component;

import java.util.Locale;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;

/**
 * Component for managing languages
 */
public class WorkflowLanguageManager implements Component, Contextualizable
{
    /** The Workflow Language Manager ROLE */
    public static final String ROLE = WorkflowLanguageManager.class.getName();
    
    /** The context */
    protected Context _context;
    
    public void contextualize(Context context) throws ContextException
    {
        _context = context;
    }
    
    /** 
     * Get currently used language 
     * @return the language code
     */
    public String getCurrentLanguage()
    {
        Map objectModel = ContextHelper.getObjectModel(_context);
        Locale locale = org.apache.cocoon.i18n.I18nUtils.findLocale(objectModel, "locale", null, Locale.getDefault(), true);
        return locale.getLanguage();
    }
    
    /**
     * Get a set of the authorized languages for current application
     * Must be overriden by CMS to access it
     * @return a set of the languages codes
     */
    public Set<String> getLanguages()
    {
        Map objectModel = ContextHelper.getObjectModel(_context);
        Locale locale = org.apache.cocoon.i18n.I18nUtils.findLocale(objectModel, "locale", null, Locale.getDefault(), true);
        return Set.of(locale.getLanguage());
    }
    
}
