/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workflow.repository;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;

/**
 * {@link AmetysObject} abstraction defined by the following additional property:
 * <dl>
 *   <dt>workflowId
 *   <dd>the id of the workflow instance associated with the ametys object
 *   <dt>currentStepId
 *   <dd>the id of the current step associated with the ametys object
 * </dl>
 */
public interface WorkflowAwareAmetysObject extends JCRAmetysObject
{
    /**
     * Retrieves the workflow id associated with the Ametys object.
     * @return the workflow id.
     * @throws AmetysRepositoryException if an error occurs.
     */
    long getWorkflowId() throws AmetysRepositoryException;
    
    /**
     * Set the workflow id of this Ametys object.<br>
     * This method will throw Exception if the workflow id was already set on this Ametys object.
     * @param workflowId the workflow id of the object.
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setWorkflowId(long workflowId) throws AmetysRepositoryException;
    
    /**
     * Retrieves the current step id of the Ametys object
     * @return the current step id
     * @throws AmetysRepositoryException if an error occurs.
     */
    long getCurrentStepId () throws AmetysRepositoryException;
    
    /**
     * Set the current step id of the Ametys object
     * @param stepId the step id to set
     * @throws AmetysRepositoryException if an error occurs.
     */
    void setCurrentStepId (long stepId) throws AmetysRepositoryException;
}

